/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.authorization.AuthenticationHolder;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.Role;
import org.hswebframework.web.authorization.User;

public interface Authentication
extends Serializable {
    public static Optional<Authentication> current() {
        return Optional.ofNullable(AuthenticationHolder.get());
    }

    public User getUser();

    public List<Role> getRoles();

    public List<Permission> getPermissions();

    default public Optional<Role> getRole(String id) {
        if (null == id) {
            return Optional.empty();
        }
        return this.getRoles().stream().filter(role -> role.getId().equals(id)).findAny();
    }

    default public Optional<Permission> getPermission(String id) {
        if (null == id) {
            return Optional.empty();
        }
        return this.getPermissions().stream().filter(permission -> permission.getId().equals(id)).findAny();
    }

    default public boolean hasPermission(String permissionId, String ... actions) {
        return this.getPermission(permissionId).filter(permission -> actions.length == 0 || permission.getActions().containsAll(Arrays.asList(actions))).isPresent();
    }

    default public boolean hasRole(String roleId) {
        return this.getRole(roleId).isPresent();
    }

    public <T extends Serializable> Optional<T> getAttribute(String var1);

    public void setAttribute(String var1, Serializable var2);

    public void setAttributes(Map<String, Serializable> var1);

    public <T extends Serializable> T removeAttributes(String var1);

    public Map<String, Serializable> getAttributes();
}

