/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple.builder;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.PostConstruct;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilder;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.simple.AbstractDataAccessConfig;
import org.hswebframework.web.authorization.simple.SimpleCustomDataAccessConfigConfig;
import org.hswebframework.web.authorization.simple.SimpleFieldFilterDataAccessConfig;
import org.hswebframework.web.authorization.simple.SimpleFiledScopeDataAccessConfig;
import org.hswebframework.web.authorization.simple.SimpleOwnCreatedDataAccessConfig;
import org.hswebframework.web.authorization.simple.SimpleScriptDataAccessConfig;
import org.hswebframework.web.authorization.simple.builder.DataAccessConfigConvert;
import org.hswebframework.web.authorization.simple.builder.SimpleDataAccessConfigBuilder;

public class SimpleDataAccessConfigBuilderFactory
implements DataAccessConfigBuilderFactory {
    private List<String> defaultSupportConvert = Arrays.asList("CUSTOM", "OWN_CREATED", "FIELD_SCOPE", "DENY_FIELDS");
    private List<DataAccessConfigConvert> converts = new LinkedList<DataAccessConfigConvert>();

    public SimpleDataAccessConfigBuilderFactory addConvert(DataAccessConfigConvert configBuilderConvert) {
        Objects.requireNonNull(configBuilderConvert);
        this.converts.add(configBuilderConvert);
        return this;
    }

    public void setDefaultSupportConvert(List<String> defaultSupportConvert) {
        this.defaultSupportConvert = defaultSupportConvert;
    }

    public List<String> getDefaultSupportConvert() {
        return this.defaultSupportConvert;
    }

    protected DataAccessConfigConvert createJsonConfig(String supportType, Class<? extends AbstractDataAccessConfig> clazz) {
        return this.createConfig(supportType, (action, config) -> (AbstractDataAccessConfig)JSON.parseObject((String)config, (Class)clazz));
    }

    protected DataAccessConfigConvert createConfig(final String supportType, final BiFunction<String, String, ? extends DataAccessConfig> function) {
        return new DataAccessConfigConvert(){

            @Override
            public boolean isSupport(String type, String action, String config) {
                return supportType.equals(type);
            }

            @Override
            public DataAccessConfig convert(String type, String action, String config) {
                DataAccessConfig conf = (DataAccessConfig)function.apply(action, config);
                if (conf instanceof AbstractDataAccessConfig) {
                    ((AbstractDataAccessConfig)conf).setAction(action);
                }
                return conf;
            }
        };
    }

    @PostConstruct
    public void init() {
        if (this.defaultSupportConvert.contains("FIELD_SCOPE")) {
            this.converts.add(this.createJsonConfig("FIELD_SCOPE", SimpleFiledScopeDataAccessConfig.class));
        }
        if (this.defaultSupportConvert.contains("DENY_FIELDS")) {
            this.converts.add(this.createJsonConfig("DENY_FIELDS", SimpleFieldFilterDataAccessConfig.class));
        }
        if (this.defaultSupportConvert.contains("OWN_CREATED")) {
            this.converts.add(this.createConfig("OWN_CREATED", (action, config) -> new SimpleOwnCreatedDataAccessConfig((String)action)));
        }
        if (this.defaultSupportConvert.contains("SCRIPT")) {
            this.converts.add(this.createJsonConfig("SCRIPT", SimpleScriptDataAccessConfig.class));
        }
        if (this.defaultSupportConvert.contains("CUSTOM")) {
            this.converts.add(this.createConfig("CUSTOM", (action, config) -> new SimpleCustomDataAccessConfigConfig((String)config)));
        }
    }

    @Override
    public DataAccessConfigBuilder create() {
        return new SimpleDataAccessConfigBuilder(this.converts);
    }
}

