/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.loggin.aop;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.hswebframework.web.boost.aop.context.MethodInterceptorHolder;
import org.hswebframework.web.loggin.aop.AccessLoggerParser;
import org.hswebframework.web.logging.AccessLogger;
import org.hswebframework.web.logging.LoggerDefine;
import org.springframework.core.annotation.AnnotationUtils;

public class DefaultAccessLoggerParser
implements AccessLoggerParser {
    @Override
    public boolean support(Class clazz, Method method) {
        AccessLogger ann = (AccessLogger)AnnotationUtils.findAnnotation((Method)method, AccessLogger.class);
        return null != ann && !ann.ignore();
    }

    @Override
    public LoggerDefine parse(MethodInterceptorHolder holder) {
        AccessLogger methodAnn = (AccessLogger)holder.findMethodAnnotation(AccessLogger.class);
        AccessLogger classAnn = (AccessLogger)holder.findClassAnnotation(AccessLogger.class);
        String action = Stream.of(classAnn, methodAnn).filter(Objects::nonNull).map(AccessLogger::value).reduce((c, m) -> c.concat("-").concat((String)m)).orElse("");
        String describe = Stream.of(classAnn, methodAnn).filter(Objects::nonNull).map(AccessLogger::describe).flatMap(Stream::of).reduce((c, s) -> c.concat("\n").concat((String)s)).orElse("");
        return new LoggerDefine(action, describe);
    }
}

