/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.loggin.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.WebUtil;
import org.hswebframework.web.boost.aop.context.MethodInterceptorHolder;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.loggin.aop.AccessLoggerParser;
import org.hswebframework.web.logging.AccessLoggerInfo;
import org.hswebframework.web.logging.AccessLoggerListener;
import org.hswebframework.web.logging.LoggerDefine;
import org.hswebframework.web.logging.events.AccessLoggerAfterEvent;
import org.hswebframework.web.logging.events.AccessLoggerBeforeEvent;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.ClassUtils;

public class AopAccessLoggerSupport
extends StaticMethodMatcherPointcutAdvisor {
    @Autowired(required=false)
    private final List<AccessLoggerListener> listeners = new ArrayList<AccessLoggerListener>();
    @Autowired(required=false)
    private final List<AccessLoggerParser> loggerParsers = new ArrayList<AccessLoggerParser>();
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public AopAccessLoggerSupport addListener(AccessLoggerListener loggerListener) {
        if (!this.listeners.contains(loggerListener)) {
            this.listeners.add(loggerListener);
        }
        return this;
    }

    public AopAccessLoggerSupport addParser(AccessLoggerParser parser) {
        if (!this.loggerParsers.contains(parser)) {
            this.loggerParsers.add(parser);
        }
        return this;
    }

    public AopAccessLoggerSupport() {
        this.setAdvice((Advice)((MethodInterceptor)methodInvocation -> {
            Object response;
            MethodInterceptorHolder methodInterceptorHolder = MethodInterceptorHolder.create((MethodInvocation)methodInvocation);
            AccessLoggerInfo info = this.createLogger(methodInterceptorHolder);
            try {
                this.eventPublisher.publishEvent((Object)new AccessLoggerBeforeEvent(info));
                this.listeners.forEach(listener -> listener.onLogBefore(info));
                response = methodInvocation.proceed();
                info.setResponse(response);
            }
            catch (Throwable e) {
                info.setException(e);
                throw e;
            }
            finally {
                info.setResponseTime(System.currentTimeMillis());
                this.eventPublisher.publishEvent((Object)new AccessLoggerAfterEvent(info));
                this.listeners.forEach(listener -> listener.onLogger(info));
            }
            return response;
        }));
    }

    protected AccessLoggerInfo createLogger(MethodInterceptorHolder holder) {
        AccessLoggerInfo info = new AccessLoggerInfo();
        info.setId((String)IDGenerator.MD5.generate());
        info.setRequestTime(System.currentTimeMillis());
        LoggerDefine define = this.loggerParsers.stream().filter(parser -> parser.support(ClassUtils.getUserClass((Object)holder.getTarget()), holder.getMethod())).findAny().map(parser -> parser.parse(holder)).orElse(null);
        if (define != null) {
            info.setAction(define.getAction());
            info.setDescribe(define.getDescribe());
        }
        info.setParameters(holder.getArgs());
        info.setTarget(holder.getTarget().getClass());
        info.setMethod(holder.getMethod());
        HttpServletRequest request = WebUtil.getHttpServletRequest();
        if (null != request) {
            info.setHttpHeaders(WebUtil.getHeaders((HttpServletRequest)request));
            info.setIp(WebUtil.getIpAddr((HttpServletRequest)request));
            info.setHttpMethod(request.getMethod());
            info.setUrl(request.getRequestURL().toString());
        }
        return info;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean matches(Method method, Class<?> aClass) {
        return this.loggerParsers.stream().anyMatch(parser -> parser.support(aClass, method));
    }
}

