/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.loggin.aop;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import org.hswebframework.web.boost.aop.context.MethodInterceptorHolder;
import org.hswebframework.web.loggin.aop.AccessLoggerParser;
import org.hswebframework.web.logging.LoggerDefine;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class SwaggerAccessLoggerParser
implements AccessLoggerParser {
    @Override
    public boolean support(Class clazz, Method method) {
        Api api = (Api)AnnotationUtils.findAnnotation((Class)clazz, Api.class);
        ApiOperation operation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class);
        return api != null || operation != null;
    }

    @Override
    public LoggerDefine parse(MethodInterceptorHolder holder) {
        Api api = (Api)holder.findAnnotation(Api.class);
        ApiOperation operation = (ApiOperation)holder.findAnnotation(ApiOperation.class);
        String action = "";
        if (api != null) {
            action = action.concat(api.value());
        }
        if (null != operation) {
            action = StringUtils.isEmpty((Object)action) ? operation.value() : action + "-" + operation.value();
        }
        return new LoggerDefine(action, "");
    }
}

