/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.utils;

import java.util.Arrays;
import java.util.Date;
import javax.annotation.Nonnull;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.PrepareSqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.utils.time.DateFormatter;
import org.slf4j.Logger;

public class SqlUtils {
    static final SqlFragments[] Q_M_CACHE;

    public static SqlFragments createQuestionMarks(int len) {
        if (len == 0) {
            return EmptySqlFragments.INSTANCE;
        }
        int cacheSize = Q_M_CACHE.length;
        if (len < cacheSize) {
            return Q_M_CACHE[len];
        }
        int size = len / --cacheSize;
        int remainder = len % cacheSize;
        BatchSqlFragments batch = new BatchSqlFragments(size * 2 + (remainder > 0 ? 1 : 0), 0);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                batch.add(SqlFragments.COMMA);
            }
            batch.add(Q_M_CACHE[cacheSize]);
        }
        if (remainder > 0) {
            if (size > 0) {
                batch.add(SqlFragments.COMMA);
            }
            batch.add(Q_M_CACHE[remainder]);
        }
        return batch;
    }

    public static String sqlParameterToString(Object[] parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Object param : parameters) {
            if (i++ != 0) {
                builder.append(",");
            }
            builder.append(param);
            if (param instanceof NullValue) continue;
            builder.append("(");
            builder.append(param == null ? "null" : param.getClass().getSimpleName());
            builder.append(")");
        }
        return builder.toString();
    }

    public static void printSql(Logger log, SqlRequest sqlRequest) {
        if (log.isDebugEnabled() && sqlRequest.isNotEmpty()) {
            boolean hasParameter = sqlRequest.getParameters() != null && sqlRequest.getParameters().length > 0;
            log.debug("==>  {}: {}", (Object)(hasParameter ? "Preparing" : "  Execute"), (Object)sqlRequest.getSql());
            if (hasParameter) {
                log.debug("==> Parameters: {}", (Object)SqlUtils.sqlParameterToString(sqlRequest.getParameters()));
                if (sqlRequest instanceof PrepareSqlRequest) {
                    log.debug("==>     Native: {}", (Object)sqlRequest.toNativeSql());
                }
            }
        }
    }

    public static String toNativeSql(String sql, Object ... parameters) {
        if (parameters == null) {
            return sql;
        }
        String[] stringParameter = new String[parameters.length];
        int len = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            stringParameter[i] = parameter instanceof Number || parameter instanceof Boolean ? parameter.toString() : (parameter instanceof Date ? "'" + DateFormatter.toString((Date)((Date)parameter), (String)"yyyy-MM-dd HH:mm:ss") + "'" : (parameter instanceof NullValue ? "null" : (parameter == null ? "null" : "'" + parameter + "'")));
            len += stringParameter.length;
        }
        return SqlUtils.sqlParameterToString(sql, len, stringParameter);
    }

    @Nonnull
    private static String sqlParameterToString(String sql, int len, String[] stringParameter) {
        StringBuilder builder = new StringBuilder(sql.length() + len + 16);
        int parameterIndex = 0;
        int sqlLen = sql.length();
        for (int i = 0; i < sqlLen; ++i) {
            char c = sql.charAt(i);
            if (c == '?') {
                if (stringParameter.length > parameterIndex) {
                    builder.append(stringParameter[parameterIndex++]);
                    continue;
                }
                builder.append("unbound");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static {
        int defaultSize = Runtime.getRuntime().maxMemory() > 0x100000000L ? 500 : 200;
        Q_M_CACHE = new SqlFragments[Integer.getInteger("easyorm.question-marks.cache-size", defaultSize) + 1];
        for (int i = 0; i < Q_M_CACHE.length; ++i) {
            Object[] arr = new String[i];
            Arrays.fill(arr, "?");
            SqlUtils.Q_M_CACHE[i] = SqlFragments.single(String.join((CharSequence)",", (CharSequence[])arr));
        }
    }
}

