/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.CastUtil;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class OracleIndexMetadataParser
implements IndexMetadataParser {
    private static final Logger log = LoggerFactory.getLogger(OracleIndexMetadataParser.class);
    private static final String sql = "select idx.index_name,idx.table_name,idx.uniqueness,col.column_name,col.column_position,col.descend from all_ind_columns col join all_indexes idx on col.index_name = idx.index_name where idx.table_owner = ? and upper(idx.table_name) like ?";
    private static final String virtualColumnSql = "select column_name,data_default from all_tab_cols where owner = ? and upper(table_name) like ? and virtual_column='YES'";
    private static final String primaryKeyIndexSql = "select index_name from all_constraints where owner = ? and upper(table_name) like ? and constraint_type = 'P'";
    private final RDBSchemaMetadata schema;

    @Override
    public List<RDBIndexMetadata> parseTableIndex(String tableName) {
        String schemaName = this.schema.getName().toUpperCase();
        String tableUpperName = tableName.toUpperCase();
        return this.schema.findFeature(SyncSqlExecutor.ID).map(sqlExecutor -> sqlExecutor.select(SqlRequests.prepare(sql, schemaName, tableUpperName), new OracleIndexWrapper(sqlExecutor.select(SqlRequests.prepare(virtualColumnSql, schemaName, tableUpperName), ResultWrappers.lowerCase(ResultWrappers.mapStream())).map(CastUtil::cast).collect(Collectors.toMap(map -> (String)map.get("column_name"), map -> (String)map.get("data_default"))), sqlExecutor.select(SqlRequests.prepare(primaryKeyIndexSql, schemaName, tableUpperName), ResultWrappers.stream(ResultWrappers.column("index_name", String::valueOf))).collect(Collectors.toSet())))).orElseGet(() -> {
            log.warn("unsupported SyncSqlExecutor");
            return Collections.emptyList();
        });
    }

    public Optional<RDBIndexMetadata> parseByName(String name) {
        return Optional.empty();
    }

    @Override
    public List<RDBIndexMetadata> parseAll() {
        return this.parseTableIndex("%%");
    }

    @Override
    public Flux<RDBIndexMetadata> parseAllReactive() {
        return this.parseTableIndexReactive("%%");
    }

    public Mono<RDBIndexMetadata> parseByNameReactive(String name) {
        return Mono.empty();
    }

    @Override
    public Flux<RDBIndexMetadata> parseTableIndexReactive(String tableName) {
        ReactiveSqlExecutor sqlExecutor = (ReactiveSqlExecutor)this.schema.findFeatureNow(ReactiveSqlExecutor.ID);
        String schemaName = this.schema.getName().toUpperCase();
        String tableUpperName = tableName.toUpperCase();
        return Mono.zip((Mono)sqlExecutor.select(SqlRequests.prepare(virtualColumnSql, schemaName, tableUpperName), ResultWrappers.lowerCase(ResultWrappers.map())).collectMap(map -> String.valueOf(map.get("column_name")), map -> String.valueOf(map.get("data_default"))), (Mono)sqlExecutor.select(SqlRequests.prepare(primaryKeyIndexSql, schemaName, tableUpperName), ResultWrappers.column("index_name", String::valueOf)).collect(Collectors.toSet()), (x$0, x$1) -> new OracleIndexWrapper((Map<String, String>)x$0, (Set<String>)x$1)).flatMap(wrapper -> sqlExecutor.select(SqlRequests.prepare(sql, schemaName, tableUpperName), wrapper).then(Mono.fromSupplier(wrapper::getResult))).flatMapIterable(Function.identity());
    }

    private OracleIndexMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static OracleIndexMetadataParser of(RDBSchemaMetadata schema) {
        return new OracleIndexMetadataParser(schema);
    }

    class OracleIndexWrapper
    implements ResultWrapper<Map<String, String>, List<RDBIndexMetadata>> {
        private final Map<Tuple2<String, String>, RDBIndexMetadata> mappingByName = new HashMap<Tuple2<String, String>, RDBIndexMetadata>();
        private final Map<String, String> virtualColumn;
        private final Set<String> indexName;

        public OracleIndexWrapper(Map<String, String> virtualColumn, Set<String> indexName) {
            this.virtualColumn = virtualColumn;
            this.indexName = indexName;
        }

        @Override
        public Map<String, String> newRowInstance() {
            return new HashMap<String, String>();
        }

        @Override
        public void wrapColumn(ColumnWrapperContext<Map<String, String>> context) {
            if (context.getResult() == null) {
                return;
            }
            context.getRowInstance().put(context.getColumnLabel().toLowerCase(), String.valueOf(context.getResult()));
        }

        @Override
        public boolean completedWrapRow(Map<String, String> result) {
            String name = result.get("index_name");
            String tableName = result.get("table_name");
            RDBIndexMetadata metadata = this.mappingByName.computeIfAbsent((Tuple2<String, String>)Tuples.of((Object)tableName, (Object)name), tp2 -> new RDBIndexMetadata((String)tp2.getT2()));
            metadata.setTableName(tableName);
            metadata.setUnique("UNIQUE".equals(result.get("uniqueness")));
            metadata.setPrimaryKey(this.indexName.contains(metadata.getName()));
            RDBIndexMetadata.IndexColumn column = new RDBIndexMetadata.IndexColumn();
            column.setSort("ASC".equalsIgnoreCase(result.get("descend")) ? RDBIndexMetadata.IndexSort.asc : RDBIndexMetadata.IndexSort.desc);
            column.setSortIndex(Integer.parseInt(result.get("column_position")));
            String columnName = result.get("column_name");
            column.setColumn(OracleIndexMetadataParser.this.schema.getDialect().clearQuote(this.virtualColumn.getOrDefault(columnName, columnName)).toLowerCase());
            metadata.getColumns().add(column);
            return true;
        }

        @Override
        public List<RDBIndexMetadata> getResult() {
            return new ArrayList<RDBIndexMetadata>(this.mappingByName.values());
        }
    }
}

