/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.upsert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.InsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.update.UpdateSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.FunctionColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateColumn;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultSaveOrUpdateOperator
implements SaveOrUpdateOperator {
    private final RDBTableMetadata table;
    private RDBColumnMetadata idColumn;
    private volatile boolean idColumnParsed;

    public static DefaultSaveOrUpdateOperator of(RDBTableMetadata table) {
        return new DefaultSaveOrUpdateOperator(table);
    }

    public DefaultSaveOrUpdateOperator(RDBTableMetadata table) {
        this.table = table;
    }

    protected RDBColumnMetadata getIdColumn() {
        if (this.idColumnParsed) {
            return this.idColumn;
        }
        if (this.idColumn == null) {
            this.idColumn = this.table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
            this.idColumnParsed = true;
        }
        return this.idColumn;
    }

    @Override
    public SaveResultOperator execute(UpsertOperatorParameter parameter) {
        return new DefaultSaveResultOperator(() -> this.createUpsert(parameter));
    }

    protected Upsert createUpsert(UpsertOperatorParameter parameter) {
        Map mapping = parameter.getColumns().stream().collect(Collectors.toMap(FunctionColumn::getColumn, Function.identity()));
        InsertSqlBuilder insertSqlBuilder = (InsertSqlBuilder)this.table.findFeatureNow(InsertSqlBuilder.ID);
        ArrayList<SqlRequest> insert = new ArrayList<SqlRequest>();
        ArrayList<UpdateOrInsert> uoi = new ArrayList<UpdateOrInsert>();
        if (this.getIdColumn() != null) {
            InsertOperatorParameter insertParameter = new InsertOperatorParameter();
            insertParameter.getColumns().addAll(parameter.getColumns());
            InsertColumn id = (InsertColumn)mapping.getOrDefault(this.idColumn.getName(), mapping.get(this.idColumn.getAlias()));
            if (id != null) {
                UpdateSqlBuilder updateSqlBuilder = (UpdateSqlBuilder)this.table.findFeatureNow(UpdateSqlBuilder.ID);
                Set<UpsertColumn> columns = parameter.getColumns();
                block0: for (List<Object> value : parameter.getValues()) {
                    ArrayList<Term> where = new ArrayList<Term>(parameter.getWhere());
                    UpdateOperatorParameter updateParameter = new UpdateOperatorParameter();
                    updateParameter.setWhere(where);
                    int index = 0;
                    for (UpsertColumn column : columns) {
                        if (column.getColumn().equals(id.getColumn())) {
                            Object idValue = value.get(index);
                            if (idValue == null) {
                                insertParameter.getValues().add(value);
                                continue block0;
                            }
                            Term whereIdIs = new Term();
                            whereIdIs.setColumn(this.idColumn.getName());
                            whereIdIs.setValue(idValue);
                            updateParameter.getWhere().add(whereIdIs);
                        } else {
                            RDBColumnMetadata columnMetadata = this.table.getColumn(column.getColumn()).orElse(null);
                            if (column.isUpdateIgnore() || columnMetadata == null || !columnMetadata.isUpdatable() || !columnMetadata.isSaveable()) {
                                ++index;
                                continue;
                            }
                            UpdateColumn updateColumn = new UpdateColumn();
                            updateColumn.setValue(value.get(index));
                            updateColumn.setColumn(column.getColumn());
                            updateColumn.setFunction(column.getFunction());
                            updateParameter.getColumns().add(updateColumn);
                        }
                        ++index;
                    }
                    uoi.add(new UpdateOrInsert(updateSqlBuilder.build(updateParameter), () -> {
                        InsertOperatorParameter insertOperatorParameter = new InsertOperatorParameter();
                        insertOperatorParameter.getColumns().addAll(columns);
                        insertOperatorParameter.getValues().add(value);
                        return insertSqlBuilder.build(insertOperatorParameter);
                    }));
                }
            } else {
                insertParameter.getColumns().add(InsertColumn.of(this.idColumn.getName()));
                insertParameter.getValues().addAll(parameter.getValues());
            }
            if (!insertParameter.getValues().isEmpty()) {
                insert.add(insertSqlBuilder.build(insertParameter));
            }
        } else {
            InsertOperatorParameter insertParameter = new InsertOperatorParameter();
            insertParameter.setColumns(parameter.toInsertColumns());
            insertParameter.setValues(parameter.getValues());
            insert.add(insertSqlBuilder.build(insertParameter));
        }
        return new Upsert(insert, uoi);
    }

    protected class DefaultSaveResultOperator
    implements SaveResultOperator {
        Supplier<Upsert> supplier;

        @Override
        public SaveResult sync() {
            SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)DefaultSaveOrUpdateOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
            return ExceptionUtils.translation(() -> {
                Upsert upsert = this.supplier.get();
                int inserted = 0;
                int updated = 0;
                for (SqlRequest sqlRequest : upsert.insert) {
                    inserted += sqlExecutor.update(sqlRequest);
                }
                for (UpdateOrInsert updateOrInsert : upsert.upserts) {
                    int tmp = sqlExecutor.update(updateOrInsert.updateSql);
                    updated += tmp;
                    if (tmp != 0) continue;
                    inserted += sqlExecutor.update(updateOrInsert.insertSql.get());
                }
                return SaveResult.of(inserted, updated);
            }, DefaultSaveOrUpdateOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return Mono.defer(() -> {
                ReactiveSqlExecutor sqlExecutor = (ReactiveSqlExecutor)DefaultSaveOrUpdateOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID);
                Upsert upsert = this.supplier.get();
                return (Mono)sqlExecutor.update((Publisher<SqlRequest>)Flux.fromIterable(upsert.insert)).flatMap(inserted -> Flux.fromIterable(upsert.upserts).flatMap(updateOrInsert -> sqlExecutor.update((Publisher<SqlRequest>)Mono.just((Object)updateOrInsert.updateSql)).flatMap(updated -> {
                    if (updated == 0) {
                        return sqlExecutor.update((Publisher<SqlRequest>)Mono.just((Object)updateOrInsert.insertSql.get())).map(r -> SaveResult.of(r, 0));
                    }
                    return Mono.just((Object)SaveResult.of(0, updated));
                })).reduce((Object)SaveResult.of(inserted, 0), SaveResult::merge)).as(ExceptionUtils.translation(DefaultSaveOrUpdateOperator.this.table));
            });
        }

        public DefaultSaveResultOperator(Supplier<Upsert> supplier) {
            this.supplier = supplier;
        }
    }

    protected static class Upsert {
        protected List<SqlRequest> insert;
        protected List<UpdateOrInsert> upserts;

        public Upsert(List<SqlRequest> insert, List<UpdateOrInsert> upserts) {
            this.insert = insert;
            this.upserts = upserts;
        }
    }

    protected static class UpdateOrInsert {
        SqlRequest updateSql;
        Supplier<SqlRequest> insertSql;

        public SqlRequest getUpdateSql() {
            return this.updateSql;
        }

        public Supplier<SqlRequest> getInsertSql() {
            return this.insertSql;
        }

        public UpdateOrInsert(SqlRequest updateSql, Supplier<SqlRequest> insertSql) {
            this.updateSql = updateSql;
            this.insertSql = insertSql;
        }
    }
}

