/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.update;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.EmptySqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.update.UpdateSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateColumn;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateOperatorParameter;

public class DefaultUpdateSqlBuilder
extends AbstractTermsFragmentBuilder<UpdateOperatorParameter>
implements UpdateSqlBuilder {
    private RDBTableMetadata table;
    private SqlFragments PREFIX = null;

    private DefaultUpdateSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }

    public static DefaultUpdateSqlBuilder of(RDBTableMetadata table) {
        return new DefaultUpdateSqlBuilder(table);
    }

    @Override
    public SqlRequest build(UpdateOperatorParameter parameter) {
        if (this.PREFIX == null) {
            this.PREFIX = SqlFragments.of("update", this.table.getFullName(), "set");
        }
        if (CollectionUtils.isEmpty(parameter.getColumns())) {
            return EmptySqlRequest.INSTANCE;
        }
        if (CollectionUtils.isEmpty(parameter.getWhere())) {
            throw new UnsupportedOperationException("unsupported no conditions update");
        }
        int columnSize = parameter.getColumns().size();
        HashSet distinctColumns = Sets.newHashSetWithExpectedSize((int)columnSize);
        BatchSqlFragments fragments = new BatchSqlFragments(3 + columnSize, columnSize);
        fragments.add(this.PREFIX);
        int index = 0;
        for (UpdateColumn column : parameter.getColumns()) {
            SqlFragments columnFragments = EmptySqlFragments.INSTANCE;
            RDBColumnMetadata columnMetadata = this.table.getColumn(column.getColumn()).orElse(null);
            if (columnMetadata != null && columnMetadata.isUpdatable()) {
                Object value = column.getValue();
                if (value == null) continue;
                if (column instanceof NativeSql) {
                    columnFragments = SimpleSqlFragments.of(((NativeSql)((Object)column)).getSql(), ((NativeSql)((Object)column)).getParameters());
                } else if (distinctColumns.add(columnMetadata)) {
                    columnFragments = column.getFunction() != null ? new BatchSqlFragments(2, 1).addSql(columnMetadata.getQuoteName(), "=").add(((FunctionFragmentBuilder)columnMetadata.findFeatureNow(FunctionFragmentBuilder.createFeatureId(column.getFunction()))).create(columnMetadata.getName(), columnMetadata, column)) : (value instanceof NativeSql ? SimpleSqlFragments.of(Arrays.asList(columnMetadata.getQuoteName(), "=", ((NativeSql)column.getValue()).getSql()), Arrays.asList(((NativeSql)column.getValue()).getParameters())) : ((value = columnMetadata.encode(value)) instanceof NativeSql ? SimpleSqlFragments.of(Arrays.asList(columnMetadata.getQuoteName(), "=", ((NativeSql)column.getValue()).getSql()), Arrays.asList(((NativeSql)column.getValue()).getParameters())) : SimpleSqlFragments.of(Arrays.asList(columnMetadata.getQuoteName(), "= ?"), Collections.singletonList(value))));
                }
            }
            if (!columnFragments.isNotEmpty()) continue;
            if (index++ != 0) {
                fragments.add(SqlFragments.COMMA);
            }
            fragments.add(columnFragments);
        }
        if (index == 0) {
            throw new UnsupportedOperationException("No columns are updated");
        }
        fragments.add(SqlFragments.WHERE);
        SqlFragments where = this.createTermFragments(parameter, parameter.getWhere());
        if (where.isEmpty()) {
            throw new UnsupportedOperationException("Unsupported No Conditions update");
        }
        fragments.add(where);
        return fragments.toRequest();
    }

    @Override
    protected SqlFragments createTermFragments(UpdateOperatorParameter parameter, Term term) {
        return SimpleTermsFragmentBuilder.createByTable(this.table, term);
    }

    public RDBTableMetadata getTable() {
        return this.table;
    }
}

