/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mssql;

import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatureType;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.DefaultQuerySqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BlockSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;

class SqlServerQuerySqlBuilder
extends DefaultQuerySqlBuilder {
    public SqlServerQuerySqlBuilder(RDBSchemaMetadata schema) {
        super(schema);
    }

    @Override
    protected SqlRequest build(TableOrViewMetadata metadata, QueryOperatorParameter parameter) {
        BlockSqlFragments fragments = BlockSqlFragments.of();
        fragments.addBlock(FragmentBlock.before, SELECT);
        fragments.addBlock(FragmentBlock.selectColumn, this.select(parameter, metadata).orElseGet(() -> PrepareSqlFragments.of().addSql("*")));
        fragments.addBlock(FragmentBlock.selectFrom, this.from(metadata, parameter));
        if (Boolean.TRUE.equals(parameter.getForUpdate())) {
            fragments.addBlock(FragmentBlock.selectFrom, PrepareSqlFragments.of().addSql("with(updlock)"));
        }
        this.join(parameter, metadata).ifPresent(join -> fragments.addBlock(FragmentBlock.join, (SqlFragments)join));
        this.where(parameter, metadata).ifPresent(where -> fragments.addBlock(FragmentBlock.where, WHERE).addBlock(FragmentBlock.where, (SqlFragments)where));
        this.groupBy(parameter, metadata).ifPresent(groupBy -> fragments.addBlock(FragmentBlock.groupBy, GROUP_BY).addBlock(FragmentBlock.groupBy, (SqlFragments)groupBy));
        this.orderBy(parameter, metadata).ifPresent(order -> fragments.addBlock(FragmentBlock.orderBy, ORDER_BY).addBlock(FragmentBlock.orderBy, (SqlFragments)order));
        if (!Boolean.TRUE.equals(parameter.getForUpdate()) && parameter.getPageIndex() != null && parameter.getPageSize() != null) {
            return metadata.findFeature(RDBFeatureType.paginator.getId()).map(paginator -> paginator.doPaging(fragments, parameter.getPageIndex(), parameter.getPageSize())).map(SqlFragments::toRequest).orElseGet(fragments::toRequest);
        }
        return fragments.toRequest();
    }
}

