/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import java.util.List;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.AbstractTermFragmentBuilder;
import org.hswebframework.ezorm.rdb.utils.SqlUtils;

public class InTermFragmentBuilder
extends AbstractTermFragmentBuilder {
    private static final boolean SPLIT_LARGE = Boolean.parseBoolean(System.getProperty("easyorm.term.in.split-large-parameter", "true"));
    private static final int SPLIT_LARGE_SIZE = Integer.getInteger("easyorm.term.in.split-large-size", 500);
    private final String symbol;
    private final boolean not;
    private final boolean splitLargeParameter;

    public InTermFragmentBuilder(String termType, String name, boolean isNot) {
        this(termType, name, isNot, SPLIT_LARGE);
    }

    public InTermFragmentBuilder(String termType, String name, boolean isNot, boolean splitLargeParameter) {
        super(termType, name);
        this.not = isNot;
        this.symbol = isNot ? "not in(" : "in(";
        this.splitLargeParameter = splitLargeParameter;
    }

    @Override
    public SqlFragments createFragments(String columnFullName, RDBColumnMetadata column, Term term) {
        List<Object> value = this.convertList(column, term);
        if (value == null || value.isEmpty()) {
            return EmptySqlFragments.INSTANCE;
        }
        int len = value.size();
        if (!this.splitLargeParameter || len <= SPLIT_LARGE_SIZE) {
            BatchSqlFragments fragments = new BatchSqlFragments(5, 1);
            fragments.addSql(columnFullName, this.symbol).add(SqlUtils.createQuestionMarks(len)).add(SqlFragments.RIGHT_BRACKET).addParameter(value);
            return fragments;
        }
        int batch = len / SPLIT_LARGE_SIZE;
        int remainder = len % SPLIT_LARGE_SIZE;
        int size = (int)Math.ceil((double)len / (double)SPLIT_LARGE_SIZE);
        BatchSqlFragments fragments = new BatchSqlFragments(size * 4 + 1, 1);
        fragments.add(SqlFragments.LEFT_BRACKET);
        fragments.addSql(columnFullName, this.symbol);
        for (int i = 0; i < batch; ++i) {
            if (i != 0) {
                fragments.add(SqlFragments.RIGHT_BRACKET).add(this.not ? SqlFragments.AND : SqlFragments.OR).addSql(columnFullName, this.symbol);
            }
            fragments.add(SqlUtils.createQuestionMarks(SPLIT_LARGE_SIZE));
        }
        if (remainder > 0) {
            if (batch != 0) {
                fragments.add(SqlFragments.RIGHT_BRACKET).add(this.not ? SqlFragments.AND : SqlFragments.OR).addSql(columnFullName, this.symbol);
            }
            fragments.add(SqlUtils.createQuestionMarks(remainder));
        }
        fragments.add(SqlFragments.RIGHT_BRACKET);
        return fragments.add(SqlFragments.RIGHT_BRACKET).addParameter(value);
    }
}

