/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import java.util.List;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.AbstractTermFragmentBuilder;
import org.hswebframework.ezorm.rdb.supports.mssql.SqlServerDialect;
import org.hswebframework.ezorm.rdb.supports.mssql.SqlServerEnumInFragmentBuilder;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlDialect;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlEnumInFragmentBuilder;
import org.hswebframework.ezorm.rdb.supports.oracle.OracleDialect;
import org.hswebframework.ezorm.rdb.supports.oracle.OracleEnumInFragmentBuilder;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlDialect;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlEnumInFragmentBuilder;

public abstract class EnumInFragmentBuilder
extends AbstractTermFragmentBuilder {
    public static SqlFragments NOT_ZERO = SqlFragments.of("!= 0");
    public static SqlFragments IS_ZERO = SqlFragments.of("= 0");
    private final boolean not;

    public EnumInFragmentBuilder(boolean not) {
        super(not ? "nin" : "in", "\u679a\u4e3eIn");
        this.not = not;
    }

    @Override
    public SqlFragments createFragments(String columnFullName, RDBColumnMetadata column, Term term) {
        List<Object> values = this.convertList(column, term);
        long mask = 0L;
        boolean any = term.getOptions().contains("any");
        for (Object value : values) {
            if (value instanceof Number) {
                mask |= ((Number)value).longValue();
                continue;
            }
            if (!(value instanceof Enum)) continue;
            mask |= 1L << ((Enum)value).ordinal();
        }
        BatchSqlFragments _sql = new BatchSqlFragments(2, 0);
        SqlFragments sql = this.bitAnd(columnFullName, mask);
        _sql.add(sql);
        if (any) {
            _sql.add(this.not ? IS_ZERO : NOT_ZERO);
        } else {
            _sql.addSql(this.not ? "!=" : "=", columnFullName);
        }
        return _sql;
    }

    public abstract SqlFragments bitAnd(String var1, long var2);

    public static EnumInFragmentBuilder of(Dialect dialect) {
        if (dialect instanceof MysqlDialect) {
            return MysqlEnumInFragmentBuilder.in;
        }
        if (dialect instanceof PostgresqlDialect) {
            return PostgresqlEnumInFragmentBuilder.in;
        }
        if (dialect instanceof SqlServerDialect) {
            return SqlServerEnumInFragmentBuilder.in;
        }
        if (dialect instanceof OracleDialect) {
            return OracleEnumInFragmentBuilder.in;
        }
        throw new UnsupportedOperationException("unsupported db type :" + dialect);
    }

    public static EnumInFragmentBuilder ofNot(Dialect dialect) {
        if (dialect instanceof MysqlDialect) {
            return MysqlEnumInFragmentBuilder.notIn;
        }
        if (dialect instanceof PostgresqlDialect) {
            return PostgresqlEnumInFragmentBuilder.notIn;
        }
        if (dialect instanceof SqlServerDialect) {
            return SqlServerEnumInFragmentBuilder.notIn;
        }
        if (dialect instanceof OracleDialect) {
            return OracleEnumInFragmentBuilder.notIn;
        }
        throw new UnsupportedOperationException("unsupported db type :" + (Object)((Object)dialect.getType()));
    }

    public boolean isNot() {
        return this.not;
    }
}

