/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.query;

import java.util.List;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatures;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QuerySqlFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.Join;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;

public class JoinFragmentBuilder
implements QuerySqlFragmentBuilder {
    private TableOrViewMetadata metadata;

    @Override
    public SqlFragments createFragments(QueryOperatorParameter parameter) {
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        List<Join> joins = parameter.getJoins();
        for (Join join : joins) {
            this.metadata.getSchema().findTableOrView(join.getTarget()).ifPresent(target -> {
                Optional.ofNullable(join.getType()).map(Enum::name).ifPresent(xva$0 -> fragments.addSql((String)xva$0));
                fragments.addSql("join").addSql(target.getFullName()).addSql(join.getAlias()).addSql("on");
                fragments.addFragments(target.getFeature(RDBFeatures.where).map(builder -> {
                    QueryOperatorParameter joinOnParameter = new QueryOperatorParameter();
                    joinOnParameter.setFrom(target.getName());
                    joinOnParameter.setFromAlias(join.getAlias());
                    if (join.getTerms() != null) {
                        joinOnParameter.getWhere().addAll(join.getTerms());
                    }
                    return builder.createFragments(joinOnParameter);
                }).filter(SqlFragments::isNotEmpty).orElseThrow(() -> new IllegalArgumentException("join terms is empty")));
            });
        }
        return fragments;
    }

    public String getId() {
        return "joinSqlFragmentBuilder";
    }

    public String getName() {
        return "\u8868\u8fde\u63a5";
    }

    private JoinFragmentBuilder(TableOrViewMetadata metadata) {
        this.metadata = metadata;
    }

    public static JoinFragmentBuilder of(TableOrViewMetadata metadata) {
        return new JoinFragmentBuilder(metadata);
    }
}

