/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.insert;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.InsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;

public class BatchInsertSqlBuilder
implements InsertSqlBuilder {
    protected RDBTableMetadata table;
    static SqlFragments VALUES = SqlFragments.single(") values ");
    protected static SqlFragments INSERT_INTO = SqlFragments.single("insert into");

    public static BatchInsertSqlBuilder of(RDBTableMetadata table) {
        return new BatchInsertSqlBuilder(table);
    }

    protected int computeSqlSize(int columnSize, int valueSize) {
        return columnSize * valueSize * 2 + valueSize * 2 + columnSize * 3 + 2;
    }

    protected boolean isPrimaryKey(RDBColumnMetadata col) {
        return col.isPrimaryKey();
    }

    @Override
    public SqlRequest build(InsertOperatorParameter parameter) {
        Set<InsertColumn> columns = parameter.getColumns();
        List<List<Object>> valueList = parameter.getValues();
        int columnSize = columns.size();
        int valueSize = valueList.size();
        AppendableSqlFragments fragments = this.beforeBuild(parameter, new BatchSqlFragments(this.computeSqlSize(columnSize, valueSize), columnSize * valueSize));
        fragments.add(SqlFragments.LEFT_BRACKET);
        LinkedHashMap indexMapping = Maps.newLinkedHashMapWithExpectedSize((int)columns.size());
        LinkedHashMap functionValues = Maps.newLinkedHashMapWithExpectedSize((int)columns.size());
        int index = 0;
        ArrayList<Integer> primaryIndex = new ArrayList<Integer>(1);
        boolean ignoreNullColumn = parameter.getValues().size() == 1;
        for (InsertColumn column : columns) {
            RDBColumnMetadata columnMetadata = Optional.ofNullable(column.getColumn()).flatMap(this.table::getColumn).orElse(null);
            if (columnMetadata != null && columnMetadata.isInsertable()) {
                List<Object> values;
                if (this.isPrimaryKey(columnMetadata)) {
                    primaryIndex.add(index);
                }
                if (ignoreNullColumn && (index >= (values = parameter.getValues().get(0)).size() || values.get(index) instanceof NullValue || values.get(index) == null && !(columnMetadata.getDefaultValue() instanceof RuntimeDefaultValue))) {
                    ++index;
                    continue;
                }
                if (indexMapping.size() != 0) {
                    fragments.add(SqlFragments.COMMA);
                }
                fragments.addSql(columnMetadata.getQuoteName());
                indexMapping.put(index, columnMetadata);
                if (StringUtils.isNotEmpty((CharSequence)column.getFunction())) {
                    functionValues.put(index, ((FunctionFragmentBuilder)columnMetadata.findFeatureNow(FunctionFragmentBuilder.createFeatureId(column.getFunction()))).create(columnMetadata.getName(), columnMetadata, column));
                }
            }
            ++index;
        }
        if (indexMapping.isEmpty()) {
            throw new IllegalArgumentException("No operable columns");
        }
        fragments.add(VALUES);
        index = 0;
        HashSet<Object> duplicatePrimary = new HashSet<Object>(8);
        for (List<Object> values : valueList) {
            int indexSize = primaryIndex.size();
            int vSize = values.size();
            if (indexSize == 1) {
                int idx = (Integer)primaryIndex.get(0);
                if (vSize > idx && !duplicatePrimary.add(values.get(idx))) {
                    continue;
                }
            } else if (indexSize >= 1) {
                HashSet dis = Sets.newHashSetWithExpectedSize((int)indexSize);
                for (Integer i : primaryIndex) {
                    if (vSize <= i) continue;
                    dis.add(values.get(i));
                }
                if (!duplicatePrimary.add(dis)) continue;
            }
            if (index++ != 0) {
                fragments.add(SqlFragments.COMMA);
            }
            fragments.add(SqlFragments.LEFT_BRACKET);
            int valueLen = values.size();
            int vIndex = 0;
            for (Map.Entry entry : indexMapping.entrySet()) {
                Object value;
                SqlFragments function;
                int valueIndex = (Integer)entry.getKey();
                if (vIndex++ != 0) {
                    fragments.add(SqlFragments.COMMA);
                }
                if (null != (function = (SqlFragments)functionValues.get(valueIndex))) {
                    fragments.add(function);
                    continue;
                }
                RDBColumnMetadata column = (RDBColumnMetadata)entry.getValue();
                Object object = value = valueLen <= valueIndex ? null : values.get(valueIndex);
                if ((value == null || value instanceof NullValue) && column.getDefaultValue() instanceof RuntimeDefaultValue) {
                    value = column.getDefaultValue().get();
                }
                if (value instanceof NativeSql) {
                    fragments.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                if (value == null) {
                    value = NullValue.of(column.getType());
                }
                if ((value = column.encode(value)) instanceof NativeSql) {
                    fragments.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                fragments.add(SqlFragments.QUESTION_MARK).addParameter(value);
            }
            fragments.add(SqlFragments.RIGHT_BRACKET);
            this.afterValues(columns, values, fragments);
        }
        return this.afterBuild(columns, parameter, fragments).toRequest();
    }

    protected AppendableSqlFragments beforeBuild(InsertOperatorParameter parameter, AppendableSqlFragments fragments) {
        return fragments.add(INSERT_INTO).addSql(this.table.getFullName());
    }

    protected AppendableSqlFragments afterBuild(Set<InsertColumn> columns, InsertOperatorParameter parameter, AppendableSqlFragments fragments) {
        return fragments;
    }

    protected void afterValues(Set<InsertColumn> columns, List<Object> values, AppendableSqlFragments sql) {
    }

    public BatchInsertSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }
}

