/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata.dialect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.metadata.CustomDataType;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.LengthSupportDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.DataTypeBuilder;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultDialect
implements Dialect {
    private static final Logger log = LoggerFactory.getLogger(DefaultDialect.class);
    protected Map<String, DataTypeBuilder> dataTypeMappers = new HashMap<String, DataTypeBuilder>();
    protected DataTypeBuilder defaultDataTypeBuilder;
    protected Map<String, DataType> dataTypeMapping = new HashMap<String, DataType>();
    protected Map<Class<?>, JDBCType> classJDBCTypeMapping = new HashMap();

    protected void registerDataType(String symbol, DataType dataType) {
        this.dataTypeMapping.put(symbol, dataType instanceof DataTypeBuilder ? dataType : DataType.builder(dataType, meta -> symbol));
    }

    public DefaultDialect() {
        this.defaultDataTypeBuilder = meta -> meta.getType().getName().toLowerCase();
        this.registerDataType("varchar", DataType.builder(DataType.jdbc(JDBCType.VARCHAR, String.class), column -> "varchar(" + column.getLength(255) + ")"));
        this.registerDataType("nvarchar", DataType.builder(DataType.jdbc(JDBCType.NVARCHAR, String.class), column -> "nvarchar(" + column.getLength(255) + ")"));
        this.registerDataType("decimal", DataType.builder(DataType.jdbc(JDBCType.DECIMAL, BigDecimal.class), column -> "decimal(" + column.getPrecision(32) + "," + column.getScale() + ")"));
        this.registerDataType("numeric", DataType.builder(DataType.jdbc(JDBCType.NUMERIC, BigDecimal.class), column -> "numeric(" + column.getPrecision(32) + "," + column.getScale() + ")"));
        this.registerDataType("number", DataType.builder(DataType.jdbc(JDBCType.NUMERIC, BigDecimal.class), column -> "number(" + column.getPrecision(32) + "," + column.getScale() + ")"));
        this.registerDataType("bigint", JdbcDataType.of(JDBCType.BIGINT, Long.class));
        this.registerDataType("tinyint", JdbcDataType.of(JDBCType.TINYINT, Byte.class));
        this.registerDataType("timestamp", JdbcDataType.of(JDBCType.TIMESTAMP, Timestamp.class));
        this.registerDataType("date", JdbcDataType.of(JDBCType.DATE, LocalDate.class));
        this.registerDataType("time", JdbcDataType.of(JDBCType.TIME, LocalTime.class));
        this.registerDataType("long", JdbcDataType.of(JDBCType.BIGINT, Long.class));
        this.registerDataType("double", JdbcDataType.of(JDBCType.DOUBLE, Double.class));
        this.registerDataType("binary", JdbcDataType.of(JDBCType.BINARY, byte[].class));
        this.classJDBCTypeMapping.put(String.class, JDBCType.VARCHAR);
        this.classJDBCTypeMapping.put(Byte.class, JDBCType.TINYINT);
        this.classJDBCTypeMapping.put(Byte.TYPE, JDBCType.TINYINT);
        this.classJDBCTypeMapping.put(Short.class, JDBCType.SMALLINT);
        this.classJDBCTypeMapping.put(Short.TYPE, JDBCType.SMALLINT);
        this.classJDBCTypeMapping.put(Integer.class, JDBCType.INTEGER);
        this.classJDBCTypeMapping.put(Integer.TYPE, JDBCType.INTEGER);
        this.classJDBCTypeMapping.put(Character.class, JDBCType.CHAR);
        this.classJDBCTypeMapping.put(Character.TYPE, JDBCType.CHAR);
        this.classJDBCTypeMapping.put(Long.class, JDBCType.BIGINT);
        this.classJDBCTypeMapping.put(Long.TYPE, JDBCType.BIGINT);
        this.classJDBCTypeMapping.put(Double.class, JDBCType.DOUBLE);
        this.classJDBCTypeMapping.put(Double.TYPE, JDBCType.DOUBLE);
        this.classJDBCTypeMapping.put(Float.class, JDBCType.FLOAT);
        this.classJDBCTypeMapping.put(Float.TYPE, JDBCType.FLOAT);
        this.classJDBCTypeMapping.put(Boolean.class, JDBCType.BOOLEAN);
        this.classJDBCTypeMapping.put(Boolean.TYPE, JDBCType.BOOLEAN);
        this.classJDBCTypeMapping.put(byte[].class, JDBCType.BLOB);
        this.classJDBCTypeMapping.put(BigDecimal.class, JDBCType.DECIMAL);
        this.classJDBCTypeMapping.put(BigInteger.class, JDBCType.INTEGER);
        this.classJDBCTypeMapping.put(java.util.Date.class, JDBCType.TIMESTAMP);
        this.classJDBCTypeMapping.put(Date.class, JDBCType.TIMESTAMP);
        this.classJDBCTypeMapping.put(Timestamp.class, JDBCType.TIMESTAMP);
        this.classJDBCTypeMapping.put(LocalTime.class, JDBCType.TIME);
        this.classJDBCTypeMapping.put(LocalDateTime.class, JDBCType.TIMESTAMP);
        this.classJDBCTypeMapping.put(LocalDate.class, JDBCType.DATE);
        this.classJDBCTypeMapping.put(Object.class, JDBCType.OTHER);
    }

    protected void addDataTypeBuilder(JDBCType jdbcType, DataTypeBuilder mapper) {
        this.addDataTypeBuilder(jdbcType.getName().toLowerCase(), mapper);
    }

    @Override
    public void addDataTypeBuilder(String typeId, DataTypeBuilder mapper) {
        this.dataTypeMappers.put(typeId.toLowerCase(), mapper);
    }

    @Override
    public Optional<SQLType> convertSqlType(Class<?> type) {
        return Optional.ofNullable(this.classJDBCTypeMapping.get(type)).map(JDBCType.class::cast);
    }

    @Override
    public String buildColumnDataType(RDBColumnMetadata columnMetaData) {
        if (columnMetaData.getType() == null) {
            throw new UnsupportedOperationException("unknown column type : " + columnMetaData);
        }
        DataType dataType = columnMetaData.getType();
        if (dataType instanceof DataTypeBuilder) {
            return ((DataTypeBuilder)((Object)dataType)).createColumnDataType(columnMetaData);
        }
        DataTypeBuilder mapper = this.dataTypeMappers.get(dataType.getId().toLowerCase());
        if (null == mapper) {
            mapper = this.defaultDataTypeBuilder;
        }
        return mapper.createColumnDataType(columnMetaData);
    }

    @Override
    public DataType convertDataType(String dataType) {
        String type = dataType;
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
            String[] arr = dataType.substring(dataType.indexOf("(") + 1, dataType.lastIndexOf(")")).split(",");
            int length = Integer.parseInt(arr[0].trim());
            int scale = arr.length > 1 ? Integer.parseInt(arr[1].trim()) : 0;
            return this.convertDataType(type, length, scale);
        }
        return this.dataTypeMapping.getOrDefault(type.toLowerCase(), this.convertUnknownDataType(dataType));
    }

    protected DataType convertDataType(String type, int length, int scale) {
        DataType staticType = this.dataTypeMapping.get(type);
        if (staticType == null) {
            return this.convertUnknownDataType(type);
        }
        return new LengthSupportDataType(staticType, length, length, scale);
    }

    protected DataType convertUnknownDataType(String dataType) {
        JDBCType type;
        try {
            type = JDBCType.valueOf(dataType.toUpperCase());
        }
        catch (Exception e) {
            type = JDBCType.OTHER;
        }
        return CustomDataType.of(dataType, dataType, type, String.class);
    }

    protected String doClearQuote(String string) {
        if (string.startsWith(this.getQuoteStart())) {
            string = string.substring(this.getQuoteStart().length());
        }
        if (string.endsWith(this.getQuoteEnd())) {
            string = string.substring(0, string.length() - this.getQuoteEnd().length());
        }
        return string;
    }

    @Override
    public String clearQuote(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (string.contains(".")) {
            CharSequence[] arr = string.split("[.]");
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.doClearQuote((String)arr[i]);
            }
            return String.join((CharSequence)".", arr);
        }
        return this.doClearQuote(string);
    }
}

