/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import java.sql.JDBCType;
import java.sql.SQLType;
import org.hswebframework.ezorm.core.ValueCodec;

public class BooleanValueCodec
implements ValueCodec<Object, Boolean> {
    private SQLType sqlType;

    public Object encode(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean)) {
            value = "1".equals(String.valueOf(value)) || "true".equals(String.valueOf(value));
        }
        if (Boolean.TRUE.equals(value)) {
            return this.sqlType == JDBCType.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(1);
        }
        if (Boolean.FALSE.equals(value)) {
            return this.sqlType == JDBCType.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
        }
        return value;
    }

    public Boolean decode(Object data) {
        if (null == data) {
            return false;
        }
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        return "1".equals(String.valueOf(data)) || "true".equals(String.valueOf(data));
    }

    public BooleanValueCodec(SQLType sqlType) {
        this.sqlType = sqlType;
    }
}

