/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.oracle;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.InsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.DefaultSaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class OracleBatchUpsertOperator
implements SaveOrUpdateOperator {
    private final RDBTableMetadata table;
    private final OracleUpsertBatchInsertSqlBuilder builder;
    private RDBColumnMetadata idColumn;
    private final SaveOrUpdateOperator fallback;

    public OracleBatchUpsertOperator(RDBTableMetadata table) {
        this.table = table;
        this.builder = new OracleUpsertBatchInsertSqlBuilder(table);
        this.idColumn = table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
        this.fallback = new DefaultSaveOrUpdateOperator(table);
    }

    @Override
    public SaveResultOperator execute(UpsertOperatorParameter parameter) {
        if (this.idColumn == null) {
            this.idColumn = this.table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
            if (this.idColumn == null) {
                return this.fallback.execute(parameter);
            }
        }
        return new PostgresqlSaveResultOperator(() -> this.builder.build(new OracleUpsertOperatorParameter(parameter)));
    }

    private class OracleUpsertBatchInsertSqlBuilder
    implements InsertSqlBuilder {
        private final RDBTableMetadata table;

        public OracleUpsertBatchInsertSqlBuilder(RDBTableMetadata table) {
            this.table = table;
        }

        private Map<Integer, Tuple2<RDBColumnMetadata, UpsertColumn>> createColumnIndex(Set<InsertColumn> columns) {
            LinkedHashMap<Integer, Tuple2<RDBColumnMetadata, UpsertColumn>> columnMapping = new LinkedHashMap<Integer, Tuple2<RDBColumnMetadata, UpsertColumn>>(columns.size());
            int index = 0;
            for (InsertColumn column : columns) {
                RDBColumnMetadata metadata = this.table.getColumn(column.getColumn()).orElse(null);
                if (metadata == null) {
                    ++index;
                    continue;
                }
                columnMapping.put(index++, (Tuple2<RDBColumnMetadata, UpsertColumn>)Tuples.of((Object)metadata, (Object)((UpsertColumn)column)));
            }
            return columnMapping;
        }

        @Override
        public SqlRequest build(InsertOperatorParameter parameter) {
            OracleUpsertOperatorParameter upsertParameter = (OracleUpsertOperatorParameter)parameter;
            PrepareSqlFragments fragments = PrepareSqlFragments.of();
            fragments.addSql("merge into", this.table.getFullName(), "t using (");
            Map<Integer, Tuple2<RDBColumnMetadata, UpsertColumn>> columnMapping = this.createColumnIndex(parameter.getColumns());
            boolean notContainsId = true;
            int rowIndex = 0;
            for (List<Object> values : parameter.getValues()) {
                int valueIndex = 0;
                if (rowIndex > 0) {
                    fragments.addSql("union all ");
                }
                fragments.addSql("(select");
                for (Map.Entry<Integer, Tuple2<RDBColumnMetadata, UpsertColumn>> entry : columnMapping.entrySet()) {
                    Object value;
                    int index = entry.getKey();
                    RDBColumnMetadata column = (RDBColumnMetadata)entry.getValue().getT1();
                    Object object = value = values.size() > index ? values.get(index) : null;
                    if (column.isPrimaryKey()) {
                        notContainsId = false;
                    }
                    if (valueIndex > 0) {
                        fragments.addSql(",");
                    }
                    if ((value == null || value instanceof NullValue) && column.getDefaultValue() instanceof RuntimeDefaultValue) {
                        value = column.getDefaultValue().get();
                    }
                    if (value instanceof NativeSql) {
                        throw new UnsupportedOperationException("upsert unsupported NativeSql");
                    }
                    if (value == null) {
                        value = NullValue.of(column.getType());
                    }
                    fragments.addSql("? as ", column.getQuoteName()).addParameter(column.encode(value));
                    ++valueIndex;
                }
                if (notContainsId) {
                    if (OracleBatchUpsertOperator.this.idColumn.getDefaultValue() == null) {
                        throw new UnsupportedOperationException("column " + OracleBatchUpsertOperator.this.idColumn.getFullName() + " unsupported default value");
                    }
                    Object value = OracleBatchUpsertOperator.this.idColumn.getDefaultValue().get();
                    fragments.addSql(",");
                    if (value instanceof NativeSql) {
                        fragments.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters()).addSql("as", OracleBatchUpsertOperator.this.idColumn.getQuoteName());
                    } else {
                        fragments.addSql("? as", OracleBatchUpsertOperator.this.idColumn.getQuoteName()).addParameter(value);
                    }
                }
                fragments.addSql("from dual) ");
                ++rowIndex;
            }
            fragments.addSql(") t2 on (", OracleBatchUpsertOperator.this.idColumn.getFullName("t"), "=", OracleBatchUpsertOperator.this.idColumn.getFullName("t2"), ")");
            PrepareSqlFragments insertColumns = PrepareSqlFragments.of();
            PrepareSqlFragments insertValues = PrepareSqlFragments.of();
            PrepareSqlFragments update = PrepareSqlFragments.of();
            boolean ignoreNullColumn = parameter.getValues().size() == 1;
            List<Object> firstValues = parameter.getValues().get(0);
            int insertIndex = 0;
            int insertValueIndex = 0;
            int updateIndex = 0;
            if (notContainsId) {
                insertIndex = 1;
                insertColumns.addSql(OracleBatchUpsertOperator.this.idColumn.getQuoteName());
                insertValues.addSql(OracleBatchUpsertOperator.this.idColumn.getFullName("t2"));
            }
            for (Tuple2<RDBColumnMetadata, UpsertColumn> columnBind : columnMapping.values()) {
                RDBColumnMetadata column = (RDBColumnMetadata)columnBind.getT1();
                String t2Column = column.getFullName("t2");
                String tColumn = column.getFullName("t");
                boolean canInsert = column.isInsertable();
                if (canInsert && ignoreNullColumn) {
                    Object value;
                    Object object = value = firstValues.size() > insertValueIndex ? firstValues.get(insertValueIndex) : null;
                    if (value == null || value instanceof NullValue) {
                        canInsert = false;
                    }
                }
                ++insertValueIndex;
                if (canInsert) {
                    if (insertIndex > 0) {
                        insertColumns.addSql(",");
                        insertValues.addSql(",");
                    }
                    insertColumns.addSql(column.getQuoteName());
                    insertValues.addSql(t2Column);
                    ++insertIndex;
                }
                if (column.isPrimaryKey() || !column.isUpdatable() || !column.isSaveable() || ((UpsertColumn)columnBind.getT2()).isUpdateIgnore()) continue;
                if (updateIndex > 0) {
                    update.addSql(",");
                }
                update.addSql(tColumn, "=", "NVL(" + t2Column + "," + tColumn + ")");
                ++updateIndex;
            }
            if (update.isNotEmpty() || upsertParameter.doNoThingOnConflict) {
                fragments.addSql("when matched then update set");
                fragments.addFragments(update);
            }
            fragments.addSql("when not matched then insert (");
            fragments.addFragments(insertColumns);
            fragments.addSql(") values (");
            fragments.addFragments(insertValues);
            fragments.addSql(")");
            return fragments.toRequest();
        }
    }

    private class PostgresqlSaveResultOperator
    implements SaveResultOperator {
        Supplier<SqlRequest> sqlRequest;

        @Override
        public SaveResult sync() {
            return ExceptionUtils.translation(() -> {
                SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)OracleBatchUpsertOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
                int updated = sqlExecutor.update(this.sqlRequest.get());
                return SaveResult.of(0, updated);
            }, OracleBatchUpsertOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return (Mono)((Mono)Mono.fromSupplier(this.sqlRequest).as(((ReactiveSqlExecutor)OracleBatchUpsertOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID))::update)).map(i -> SaveResult.of(0, i)).as(ExceptionUtils.translation(OracleBatchUpsertOperator.this.table));
        }

        public PostgresqlSaveResultOperator(Supplier<SqlRequest> sqlRequest) {
            this.sqlRequest = sqlRequest;
        }
    }

    class OracleUpsertOperatorParameter
    extends InsertOperatorParameter {
        private boolean doNoThingOnConflict;
        private List<Term> where;

        public OracleUpsertOperatorParameter(UpsertOperatorParameter parameter) {
            this.doNoThingOnConflict = parameter.isDoNothingOnConflict();
            this.setColumns(parameter.toInsertColumns());
            this.setValues(parameter.getValues());
            this.where = parameter.getWhere();
        }
    }
}

