/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.CastUtil;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OracleIndexMetadataParser
implements IndexMetadataParser {
    private static final Logger log = LoggerFactory.getLogger(OracleIndexMetadataParser.class);
    private static final String sql = "select idx.index_name,idx.table_name,idx.uniqueness,col.column_name,col.column_position,col.descend from all_ind_columns col join all_indexes idx on col.index_name = idx.index_name where idx.table_owner=? and upper(idx.table_name)= ?";
    private static final String virtualColumnSql = "select column_name,data_default from all_tab_cols where owner=? and upper(table_name) = ? and virtual_column='YES'";
    private static final String primaryKeyIndexSql = "select index_name from all_constraints where owner=? and upper(table_name) = ? and constraint_type = 'P'";
    private final RDBSchemaMetadata schema;

    @Override
    public List<RDBIndexMetadata> parseTableIndex(String tableName) {
        String schemaName = this.schema.getName().toUpperCase();
        String tableUpperName = tableName.toUpperCase();
        return this.schema.findFeature(SyncSqlExecutor.ID).map(sqlExecutor -> sqlExecutor.select(SqlRequests.prepare(sql, schemaName, tableUpperName), new OracleIndexWrapper(sqlExecutor.select(SqlRequests.prepare(virtualColumnSql, schemaName, tableUpperName), ResultWrappers.lowerCase(ResultWrappers.mapStream())).map(CastUtil::cast).collect(Collectors.toMap(map -> (String)map.get("column_name"), map -> (String)map.get("data_default"))), sqlExecutor.select(SqlRequests.prepare(primaryKeyIndexSql, schemaName, tableUpperName), ResultWrappers.stream(ResultWrappers.column("index_name", String::valueOf))).collect(Collectors.toSet())))).orElseGet(() -> {
            log.warn("unsupported SyncSqlExecutor");
            return Collections.emptyList();
        });
    }

    public Optional<RDBIndexMetadata> parseByName(String name) {
        return Optional.empty();
    }

    @Override
    public List<RDBIndexMetadata> parseAll() {
        return Collections.emptyList();
    }

    @Override
    public Flux<RDBIndexMetadata> parseAllReactive() {
        return Flux.empty();
    }

    public Mono<RDBIndexMetadata> parseByNameReactive(String name) {
        return Mono.empty();
    }

    @Override
    public Flux<RDBIndexMetadata> parseTableIndexReactive(String tableName) {
        return Flux.empty();
    }

    private OracleIndexMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static OracleIndexMetadataParser of(RDBSchemaMetadata schema) {
        return new OracleIndexMetadataParser(schema);
    }

    class OracleIndexWrapper
    implements ResultWrapper<Map<String, String>, List<RDBIndexMetadata>> {
        private Map<String, RDBIndexMetadata> mappingByName = new HashMap<String, RDBIndexMetadata>();
        private Map<String, String> virtualColumn;
        private Set<String> indexName;

        public OracleIndexWrapper(Map<String, String> virtualColumn, Set<String> indexName) {
            this.virtualColumn = virtualColumn;
            this.indexName = indexName;
        }

        @Override
        public Map<String, String> newRowInstance() {
            return new HashMap<String, String>();
        }

        @Override
        public void wrapColumn(ColumnWrapperContext<Map<String, String>> context) {
            if (context.getResult() == null) {
                return;
            }
            context.getRowInstance().put(context.getColumnLabel().toLowerCase(), String.valueOf(context.getResult()));
        }

        @Override
        public boolean completedWrapRow(Map<String, String> result) {
            RDBIndexMetadata metadata = this.mappingByName.computeIfAbsent(result.get("index_name"), RDBIndexMetadata::new);
            metadata.setTableName(result.get("table_name"));
            metadata.setUnique("UNIQUE".equals(result.get("uniqueness")));
            metadata.setPrimaryKey(this.indexName.contains(metadata.getName()));
            RDBIndexMetadata.IndexColumn column = new RDBIndexMetadata.IndexColumn();
            column.setSort("ASC".equalsIgnoreCase(result.get("descend")) ? RDBIndexMetadata.IndexSort.asc : RDBIndexMetadata.IndexSort.desc);
            column.setSortIndex(Integer.parseInt(result.get("column_position")));
            String columnName = result.get("column_name");
            column.setColumn(OracleIndexMetadataParser.this.schema.getDialect().clearQuote(this.virtualColumn.getOrDefault(columnName, columnName)).toLowerCase());
            metadata.getColumns().add(column);
            return true;
        }

        @Override
        public List<RDBIndexMetadata> getResult() {
            return new ArrayList<RDBIndexMetadata>(this.mappingByName.values());
        }
    }
}

