/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import java.sql.SQLException;
import java.util.Collections;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.operator.ExceptionTranslation;

public class MysqlJDBCExceptionTranslation
implements ExceptionTranslation {
    private final RDBSchemaMetadata schema;

    @Override
    public Throwable translate(Throwable e) {
        SQLException exception;
        if (e instanceof SQLException && ((exception = (SQLException)e).getErrorCode() == 1062 || exception.getErrorCode() == 1022)) {
            throw new DuplicateKeyException(true, Collections.emptyList(), e);
        }
        return e;
    }

    private MysqlJDBCExceptionTranslation(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static MysqlJDBCExceptionTranslation of(RDBSchemaMetadata schema) {
        return new MysqlJDBCExceptionTranslation(schema);
    }
}

