/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QuerySqlFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.ForeignKeyTermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;

public class QueryTermsFragmentBuilder
extends AbstractTermsFragmentBuilder<QueryOperatorParameter>
implements QuerySqlFragmentBuilder {
    private final TableOrViewMetadata metaData;
    private final Set<String> alias;

    protected QueryTermsFragmentBuilder(TableOrViewMetadata metaData, Set<String> alias) {
        this.metaData = metaData;
        this.alias = alias;
    }

    public static QueryTermsFragmentBuilder of(TableOrViewMetadata metadata) {
        return QueryTermsFragmentBuilder.of(metadata, Collections.emptySet());
    }

    public static QueryTermsFragmentBuilder of(TableOrViewMetadata metaData, Set<String> alias) {
        return new QueryTermsFragmentBuilder(metaData, alias);
    }

    public String getId() {
        return "queryTermsFragmentBuilder";
    }

    public String getName() {
        return "\u67e5\u8be2\u6761\u4ef6";
    }

    @Override
    protected SqlFragments createTermFragments(QueryOperatorParameter parameter, Term term) {
        String columnName = term.getColumn();
        if (columnName == null) {
            return EmptySqlFragments.INSTANCE;
        }
        if (columnName.contains(".")) {
            String[] arr = columnName.split("[.]");
            if (this.metaData.equalsNameOrAlias(arr[0]) || arr[0].equals(parameter.getFromAlias()) || this.alias.contains(arr[0])) {
                columnName = arr[1];
            } else {
                return parameter.findJoin(arr[0]).flatMap(join -> this.metaData.getSchema().getTableOrView(join.getTarget()).flatMap(tableOrView -> tableOrView.getColumn(arr[1])).flatMap(column -> column.findFeature(TermFragmentBuilder.createFeatureId(term.getTermType())).map(termFragment -> termFragment.createFragments(this.createColumnFullName((RDBColumnMetadata)column, join.getAlias()), (RDBColumnMetadata)column, term)))).orElseGet(() -> this.metaData.getForeignKey(arr[0]).flatMap(key -> key.getSource().findFeature(ForeignKeyTermFragmentBuilder.ID).map(builder -> builder.createFragments(parameter.getFromAlias(), (ForeignKeyMetadata)key, this.createForeignKeyTerm((ForeignKeyMetadata)key, term)))).orElse(EmptySqlFragments.INSTANCE));
            }
        }
        return this.metaData.getColumn(columnName).flatMap(column -> column.findFeature(TermFragmentBuilder.createFeatureId(term.getTermType())).map(termFragment -> termFragment.createFragments(this.createColumnFullName((RDBColumnMetadata)column, parameter.getFromAlias()), (RDBColumnMetadata)column, term))).orElse(EmptySqlFragments.INSTANCE);
    }

    protected List<Term> createForeignKeyTerm(ForeignKeyMetadata keyMetadata, Term term) {
        Term copy = term.clone();
        term.setTerms(new LinkedList());
        return Collections.singletonList(copy);
    }

    @Override
    public SqlFragments createFragments(QueryOperatorParameter parameter) {
        return this.createTermFragments(parameter, parameter.getWhere());
    }

    protected String createColumnFullName(RDBColumnMetadata column, String fromAlias) {
        return column.getFullName(fromAlias);
    }
}

