/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetadata;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;

public class SimpleColumnMapping
implements EntityColumnMapping {
    private Class<?> entityType;
    private Supplier<? extends TableOrViewMetadata> metadata;

    public static SimpleColumnMapping of(Class<?> type, TableOrViewMetadata metadata) {
        return SimpleColumnMapping.of(type, () -> metadata);
    }

    @Override
    public Optional<RDBColumnMetadata> getColumnByProperty(String property) {
        return this.metadata.get().findColumn(property);
    }

    @Override
    public Optional<String> getPropertyByColumnName(String columnName) {
        return this.metadata.get().findColumn(columnName).map(AbstractColumnMetadata::getAlias);
    }

    @Override
    public Optional<RDBColumnMetadata> getColumnByName(String columnName) {
        return this.metadata.get().findColumn(columnName);
    }

    @Override
    public Map<String, String> getColumnPropertyMapping() {
        return this.metadata.get().getColumns().stream().collect(Collectors.toMap(AbstractColumnMetadata::getName, AbstractColumnMetadata::getAlias));
    }

    @Override
    public TableOrViewMetadata getTable() {
        return this.metadata.get();
    }

    public String getId() {
        return "SimpleColumnMapping";
    }

    public String getName() {
        return "SimpleColumnMapping";
    }

    private SimpleColumnMapping(Class<?> entityType, Supplier<? extends TableOrViewMetadata> metadata) {
        this.entityType = entityType;
        this.metadata = metadata;
    }

    public static SimpleColumnMapping of(Class<?> entityType, Supplier<? extends TableOrViewMetadata> metadata) {
        return new SimpleColumnMapping(entityType, metadata);
    }

    @Override
    public Class<?> getEntityType() {
        return this.entityType;
    }
}

