/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jdk.nashorn.api.scripting.JSObject;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JsonValueCodec
implements ValueCodec<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(JsonValueCodec.class);
    public static final ObjectMapper defaultMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL).setTimeZone(TimeZone.getDefault());
    private final JavaType jacksonType;
    private final Class<?> targetType;
    private ObjectMapper mapper = defaultMapper;

    public static JsonValueCodec of(Class<?> targetType) {
        return new JsonValueCodec(targetType, defaultMapper.getTypeFactory().constructType(targetType));
    }

    public static JsonValueCodec ofCollection(Class<? extends Collection> targetType, Class<?> elementType) {
        return new JsonValueCodec(targetType, (JavaType)defaultMapper.getTypeFactory().constructCollectionType(targetType, elementType));
    }

    public static JsonValueCodec ofMap(Class<? extends Map> targetType, Class<?> keyType, Class<?> valueType) {
        return new JsonValueCodec(targetType, (JavaType)defaultMapper.getTypeFactory().constructMapType(targetType, keyType, valueType));
    }

    public static JsonValueCodec ofField(Field field) {
        Class type;
        Class targetType = type = field.getType();
        Type genericType = field.getGenericType();
        JavaType jacksonType = null;
        if (type == Mono.class || type == Flux.class) {
            targetType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        if (Map.class.isAssignableFrom(targetType)) {
            if (genericType instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                jacksonType = defaultMapper.getTypeFactory().constructMapType(targetType, (Class)types[0], (Class)types[1]);
            }
        } else if (Collection.class.isAssignableFrom(targetType)) {
            if (genericType instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                jacksonType = defaultMapper.getTypeFactory().constructCollectionType(targetType, (Class)types[0]);
            }
        } else if (targetType.isArray()) {
            jacksonType = defaultMapper.getTypeFactory().constructArrayType(targetType.getComponentType());
        }
        if (jacksonType == null) {
            jacksonType = defaultMapper.getTypeFactory().constructType((Type)targetType);
        }
        return new JsonValueCodec(type, jacksonType);
    }

    public JsonValueCodec(Class<?> targetType, JavaType type) {
        this.jacksonType = type;
        this.targetType = targetType;
    }

    public Object encode(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof JSObject) {
            value = this.convertJSObject((JSObject)value);
        }
        return this.mapper.writeValueAsString(value);
    }

    private Object convertJSObject(JSObject jsObject) {
        if (jsObject.isArray()) {
            return jsObject.values().stream().map(obj -> {
                if (obj instanceof JSObject) {
                    return this.convertJSObject((JSObject)obj);
                }
                return obj;
            }).collect(Collectors.toList());
        }
        if (jsObject instanceof Map) {
            HashMap newMap = new HashMap(((Map)jsObject).size());
            for (Map.Entry entry : ((Map)jsObject).entrySet()) {
                Object val = entry.getValue();
                if (val instanceof JSObject) {
                    val = this.convertJSObject((JSObject)val);
                }
                newMap.put(entry.getKey(), val);
            }
            return newMap;
        }
        return JSON.toJSON((Object)jsObject);
    }

    protected Object doRead(String str) {
        return this.mapper.readValue(str, this.jacksonType);
    }

    protected Object doRead(InputStream stream) {
        return this.mapper.readValue(stream, this.jacksonType);
    }

    /*
     * Loose catch block
     */
    public Object decode(Object data) {
        try {
            Object target;
            block25: {
                target = data;
                if (data instanceof java.sql.Clob) {
                    target = this.mapper.readValue(((java.sql.Clob)data).getCharacterStream(), this.jacksonType);
                } else if (data instanceof java.sql.Blob) {
                    target = this.mapper.readValue(((java.sql.Blob)data).getBinaryStream(), this.jacksonType);
                } else if (data instanceof InputStream) {
                    target = this.mapper.readValue((InputStream)data, this.jacksonType);
                } else if (data instanceof byte[]) {
                    target = this.mapper.readValue((byte[])data, this.jacksonType);
                } else if (data instanceof String) {
                    target = this.mapper.readValue((String)data, this.jacksonType);
                } else {
                    if (data instanceof ByteBuffer) {
                        return this.doRead((InputStream)new ByteBufferBackedInputStream((ByteBuffer)data));
                    }
                    if (FeatureUtils.r2dbcIsAlive()) {
                        Mono mono = null;
                        if (data instanceof Clob) {
                            mono = Flux.from((Publisher)((Clob)data).stream()).collect(Collectors.joining()).map(this::doRead);
                        } else if (data instanceof Blob) {
                            mono = Mono.from((Publisher)((Blob)data).stream()).map(ByteBufferBackedInputStream::new).map(this::doRead);
                        }
                        if (mono != null) {
                            if (this.targetType == Mono.class || this.targetType == Publisher.class) {
                                return mono;
                            }
                            if (this.targetType == Flux.class) {
                                return mono.flux();
                            }
                            target = mono.toFuture().get(10L, TimeUnit.SECONDS);
                        }
                    }
                }
                if (this.targetType.isInstance(target)) {
                    return target;
                }
                if (this.targetType == Mono.class || this.targetType == Publisher.class) {
                    return target == null ? Mono.empty() : Mono.just((Object)target);
                }
                if (this.targetType != Flux.class) break block25;
                return target == null ? Flux.empty() : Flux.just((Object)target);
            }
            log.warn("unsupported json format:{}", data);
            return target;
        }
        catch (Throwable e) {
            log.error("decode json error {}", data, (Object)e);
            return null;
            {
                catch (Throwable $ex) {
                    throw $ex;
                }
            }
        }
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

