/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.meta.AbstractSchemaMetadata;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.core.meta.ObjectType;
import org.hswebframework.ezorm.rdb.metadata.AbstractTableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.DefaultValueCodecFactory;
import org.hswebframework.ezorm.rdb.metadata.RDBDatabaseMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatureType;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatures;
import org.hswebframework.ezorm.rdb.metadata.RDBObjectType;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.builder.DefaultQuerySqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CommonAlterTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CommonCreateIndexSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CommonCreateTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CommonDropIndexSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.DefaultForeignKeyTermFragmentBuilder;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RDBSchemaMetadata
extends AbstractSchemaMetadata {
    private final List<ObjectType> allObjectType = Arrays.asList(new ObjectType[]{RDBObjectType.table, RDBObjectType.view});

    public RDBSchemaMetadata(String name) {
        this.addFeature(DefaultQuerySqlBuilder.of(this));
        this.addFeature(RDBFeatures.eq);
        this.addFeature(RDBFeatures.not);
        this.addFeature(RDBFeatures.gt);
        this.addFeature(RDBFeatures.gte);
        this.addFeature(RDBFeatures.lt);
        this.addFeature(RDBFeatures.lte);
        this.addFeature(RDBFeatures.like);
        this.addFeature(RDBFeatures.nlike);
        this.addFeature(RDBFeatures.in);
        this.addFeature(RDBFeatures.notIn);
        this.addFeature(RDBFeatures.between);
        this.addFeature(RDBFeatures.notBetween);
        this.addFeature(RDBFeatures.eq);
        this.addFeature(RDBFeatures.isNull);
        this.addFeature(RDBFeatures.notNull);
        this.addFeature(DefaultForeignKeyTermFragmentBuilder.INSTANCE);
        this.addFeature(RDBFeatures.count);
        this.addFeature(RDBFeatures.sum);
        this.addFeature(RDBFeatures.max);
        this.addFeature(RDBFeatures.min);
        this.addFeature(RDBFeatures.avg);
        this.addFeature(CommonCreateTableSqlBuilder.INSTANCE);
        this.addFeature(CommonAlterTableSqlBuilder.INSTANCE);
        this.addFeature(CommonCreateIndexSqlBuilder.INSTANCE);
        this.addFeature(CommonDropIndexSqlBuilder.INSTANCE);
        this.addFeature(DefaultValueCodecFactory.COMMONS);
        this.setName(name);
    }

    public RDBDatabaseMetadata getDatabase() {
        return (RDBDatabaseMetadata)super.getDatabase();
    }

    public Optional<RDBTableMetadata> getTable(String name, boolean autoLoad) {
        if (name.contains(".")) {
            return this.findTableOrView(name).map(RDBTableMetadata.class::cast);
        }
        return this.getObject(RDBObjectType.table, name, autoLoad);
    }

    public Optional<RDBTableMetadata> getTable(String name) {
        if (name.contains(".")) {
            return this.findTableOrView(name).map(RDBTableMetadata.class::cast);
        }
        return this.getObject(RDBObjectType.table, name);
    }

    public Mono<RDBTableMetadata> getTableReactive(String name) {
        return this.getTableReactive(name, true);
    }

    public Mono<RDBTableMetadata> getTableReactive(String name, boolean autoLoad) {
        if (name.contains(".")) {
            return this.findTableOrViewReactive(name).map(RDBTableMetadata.class::cast);
        }
        return this.getObjectReactive(RDBObjectType.table, name, autoLoad);
    }

    public Mono<TableOrViewMetadata> getTableOrViewReactive(String name, boolean autoLoad) {
        return this.getTableReactive(name, autoLoad).cast(TableOrViewMetadata.class).switchIfEmpty(Mono.defer(() -> this.getViewReactive(name, autoLoad).cast(TableOrViewMetadata.class)));
    }

    public Mono<TableOrViewMetadata> getTableOrViewReactive(String name) {
        return this.getTableOrViewReactive(name, true);
    }

    public Mono<RDBViewMetadata> getViewReactive(String name) {
        return this.getObjectReactive(RDBObjectType.view, name);
    }

    public Mono<RDBViewMetadata> getViewReactive(String name, boolean autoLoad) {
        return this.getObjectReactive(RDBObjectType.view, name, autoLoad);
    }

    public Optional<RDBViewMetadata> getView(String name, boolean autoLoad) {
        return this.getObject(RDBObjectType.view, name, autoLoad);
    }

    public Optional<RDBViewMetadata> getView(String name) {
        return this.getView(name, true);
    }

    public void addTable(RDBTableMetadata metadata) {
        metadata.setSchema(this);
        this.addObject(metadata);
    }

    public Mono<TableOrViewMetadata> findTableOrViewReactive(String name) {
        return this.getTableOrViewReactive(name, false).switchIfEmpty(this.getDatabase().getTableOrViewReactive(name));
    }

    public Optional<TableOrViewMetadata> findTableOrView(String name) {
        Optional<TableOrViewMetadata> current = this.getTableOrView(name, false);
        if (current.isPresent()) {
            return current;
        }
        return this.getDatabase().getTableOrView(name);
    }

    public Optional<TableOrViewMetadata> getTableOrView(String name, boolean autoLoad) {
        return Optional.of(this.getTable(name, autoLoad).map(AbstractTableOrViewMetadata.class::cast)).filter(Optional::isPresent).orElseGet(() -> this.getView(name, autoLoad).map(AbstractTableOrViewMetadata.class::cast)).map(TableOrViewMetadata.class::cast);
    }

    public Optional<TableOrViewMetadata> getTableOrView(String name) {
        return this.getTableOrView(name, true);
    }

    protected <T extends ObjectMetadata> List<T> loadMetadata(ObjectType type) {
        return super.loadMetadata(type).stream().map(this::metadataParsed).collect(Collectors.toList());
    }

    protected <T extends ObjectMetadata> Flux<T> loadMetadataReactive(ObjectType type) {
        return super.loadMetadataReactive(type).map(this::metadataParsed);
    }

    protected <T extends ObjectMetadata> T metadataParsed(T metadata) {
        if (metadata instanceof AbstractTableOrViewMetadata) {
            ((AbstractTableOrViewMetadata)metadata).setSchema(this);
        }
        return metadata;
    }

    protected <T extends ObjectMetadata> T loadMetadata(ObjectType type, String name) {
        ObjectMetadata metadata = super.loadMetadata(type, name);
        return (T)this.metadataParsed(metadata);
    }

    protected <T extends ObjectMetadata> Mono<T> loadMetadataReactive(ObjectType type, String name) {
        return super.loadMetadataReactive(type, name).map(this::metadataParsed);
    }

    public RDBTableMetadata newTable(String name) {
        RDBTableMetadata tableMetadata = new RDBTableMetadata(name);
        tableMetadata.setSchema(this);
        return tableMetadata;
    }

    public void loadAllTable() {
        this.loadMetadata(RDBObjectType.table).forEach(table -> this.addTable((RDBTableMetadata)table));
    }

    public Mono<Void> loadAllTableReactive() {
        return this.loadMetadataReactive(RDBObjectType.table).doOnNext(table -> this.addTable((RDBTableMetadata)table)).then();
    }

    public List<ObjectType> getAllObjectType() {
        return this.allObjectType;
    }

    public Dialect getDialect() {
        return Optional.ofNullable(this.getDatabase()).map(RDBDatabaseMetadata::getDialect).orElseGet(() -> this.getFeatures(RDBFeatureType.dialect).stream().findFirst().orElse(null));
    }

    public Optional<TableOrViewMetadata> removeTableOrView(String name) {
        return this.removeObject(RDBObjectType.table, name).map(Optional::of).orElseGet(() -> this.removeObject(RDBObjectType.view, name));
    }

    public RDBSchemaMetadata clone() {
        return (RDBSchemaMetadata)super.clone();
    }

    public String toString() {
        return "schema " + this.getName() + " (" + ((Object)((Object)this)).getClass().getSimpleName() + ")\n" + FeatureUtils.featureToString(this.getFeatureList());
    }
}

