/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyColumn;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QuerySqlFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.Join;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.query.SelectColumn;

public class SelectColumnFragmentBuilder
implements QuerySqlFragmentBuilder {
    private TableOrViewMetadata metadata;

    public String getId() {
        return "selectColumnFragmentBuilder";
    }

    public String getName() {
        return "\u67e5\u8be2\u5217";
    }

    private Set<SelectColumn> getAllSelectColumn(String ownerAlias, Set<String> excludes, TableOrViewMetadata metadata) {
        return metadata.getColumns().stream().map(columnMetadata -> Optional.ofNullable(ownerAlias).map(alias -> SelectColumn.of(alias.concat(".").concat(columnMetadata.getName()), alias.concat(".").concat(columnMetadata.getAlias()))).orElseGet(() -> SelectColumn.of(columnMetadata.getName(), columnMetadata.getAlias()))).filter(column -> !excludes.contains(column.getColumn()) && !excludes.contains(column.getAlias())).collect(Collectors.toSet());
    }

    private Set<SelectColumn> createSelectColumns(QueryOperatorParameter parameter) {
        LinkedHashSet<SelectColumn> columns = new LinkedHashSet<SelectColumn>(parameter.getSelect());
        Set<String> excludes = parameter.getSelectExcludes();
        if (columns.isEmpty()) {
            return this.getAllSelectColumn(null, excludes, this.metadata);
        }
        LinkedHashSet<SelectColumn> realColumns = new LinkedHashSet<SelectColumn>();
        for (SelectColumn column : parameter.getSelect()) {
            String columnName = column.getColumn();
            if (column.getFunction() != null || columnName == null || excludes.contains(columnName)) {
                realColumns.add(column);
                continue;
            }
            if (columnName.contains("*")) {
                String[] arr = columnName.split("[.]");
                if (arr.length == 1 || this.metadata.equalsNameOrAlias(arr[0])) {
                    realColumns.addAll(this.getAllSelectColumn(null, excludes, this.metadata));
                    continue;
                }
                if (arr.length != 2) continue;
                parameter.findJoin(arr[0]).flatMap(join -> this.metadata.getSchema().findTableOrView(join.getTarget())).map(tar -> this.getAllSelectColumn(arr[0], excludes, (TableOrViewMetadata)tar)).map(Optional::of).orElseGet(() -> this.metadata.getForeignKey(arr[0]).filter(ForeignKeyMetadata::isAutoJoin).map(ForeignKeyMetadata::getTarget).map(tar -> this.getAllSelectColumn(arr[0], excludes, (TableOrViewMetadata)tar))).ifPresent(realColumns::addAll);
                continue;
            }
            realColumns.add(column);
        }
        return realColumns;
    }

    @Override
    public SqlFragments createFragments(QueryOperatorParameter parameter) {
        Set<SelectColumn> columns = this.createSelectColumns(parameter);
        PrepareSqlFragments fragments = columns.stream().map(column -> this.createFragments(parameter, (SelectColumn)column)).filter(Objects::nonNull).reduce(PrepareSqlFragments.of(), (main, source) -> main.addFragments((SqlFragments)source).addSql(","));
        fragments.removeLastSql();
        return fragments;
    }

    private String getAlias(String owner, RDBColumnMetadata metadata, SelectColumn column) {
        if (column.getAlias() != null) {
            return this.metadata.getDialect().quote(column.getAlias(), false);
        }
        if (metadata == null) {
            return null;
        }
        String alias = metadata.getAlias();
        if (alias.contains(".")) {
            return alias;
        }
        if (owner != null) {
            alias = owner.concat(".").concat(alias);
        }
        return metadata.getDialect().quote(alias, false);
    }

    protected List<Join> createJoin(String owner, String target, ForeignKeyMetadata key) {
        ArrayList<Join> joins = new ArrayList<Join>();
        for (ForeignKeyMetadata middleForeignKey : key.getMiddleForeignKeys()) {
            Join join = new Join();
            for (ForeignKeyColumn column : middleForeignKey.getColumns()) {
                PrepareSqlFragments condition = PrepareSqlFragments.of();
                condition.addSql(column.getSourceColumn().getFullName(key.getAlias()));
                condition.addSql("=").addSql(column.getTargetColumn().getFullName(middleForeignKey.getAlias()));
                join.getTerms().add((Term)SqlTerm.of((String)condition.toRequest().getSql(), (Object[])new Object[0]));
            }
            if (middleForeignKey.getTerms() != null) {
                join.getTerms().addAll(middleForeignKey.getTerms());
            }
            join.setTarget(middleForeignKey.getTarget().getFullName());
            join.setType(middleForeignKey.getJoinType());
            join.addAlias(middleForeignKey.getName(), middleForeignKey.getAlias(), middleForeignKey.getTarget().getAlias(), middleForeignKey.getTarget().getName());
            joins.add(join);
        }
        Join join = new Join();
        join.setType(key.getJoinType());
        join.setTarget(key.getTarget().getFullName());
        join.setAlias(owner);
        join.addAlias(key.getTarget().getAlias());
        for (ForeignKeyColumn column : key.getColumns()) {
            PrepareSqlFragments condition = PrepareSqlFragments.of();
            condition.addSql(column.getSourceColumn().getFullName(target));
            condition.addSql("=").addSql(column.getTargetColumn().getFullName(key.getAlias()));
            join.getTerms().add((Term)SqlTerm.of((String)condition.toRequest().getSql(), (Object[])new Object[0]));
        }
        joins.add(join);
        return joins;
    }

    public PrepareSqlFragments createFragments(QueryOperatorParameter parameter, SelectColumn selectColumn) {
        RDBColumnMetadata columnMetadata;
        if (selectColumn instanceof NativeSql) {
            return PrepareSqlFragments.of().addSql(((NativeSql)((Object)selectColumn)).getSql()).addParameter(((NativeSql)((Object)selectColumn)).getParameters());
        }
        String columnStr = selectColumn.getColumn();
        if (columnStr != null && columnStr.contains(".")) {
            String[] arr = columnStr.split("[.]");
            return parameter.findJoin(arr[0]).flatMap(join -> this.metadata.getSchema().getTableOrView(join.getTarget()).flatMap(table -> table.getColumn(arr[1])).flatMap(joinColumn -> this.createFragments(joinColumn.getFullName(join.getAlias()), (RDBColumnMetadata)joinColumn, selectColumn).map(fragments -> PrepareSqlFragments.of().addFragments((SqlFragments)fragments).addSql("as", this.getAlias(join.getAlias(), (RDBColumnMetadata)joinColumn, selectColumn))))).orElseGet(() -> this.metadata.getForeignKey(arr[0]).filter(ForeignKeyMetadata::isAutoJoin).filter(key -> key.getTarget().findColumn(arr[1]).isPresent()).map(foreignKey -> {
                if (!parameter.findJoin(arr[0]).isPresent()) {
                    parameter.getJoins().addAll(this.createJoin(arr[0], parameter.getFromAlias(), (ForeignKeyMetadata)foreignKey));
                }
                PrepareSqlFragments sqlFragments = PrepareSqlFragments.of();
                RDBColumnMetadata targetColumn = foreignKey.getTarget().getColumn(arr[1]).orElse(null);
                if (targetColumn == null) {
                    return null;
                }
                sqlFragments.addSql(targetColumn.getFullName(arr[0]), "as", this.getAlias(arr[0], targetColumn, selectColumn));
                return sqlFragments;
            }).orElse(null));
        }
        RDBColumnMetadata finalColumnMetadata = columnMetadata = (RDBColumnMetadata)this.metadata.findColumn(columnStr).orElse(null);
        String columnFullName = Optional.ofNullable(finalColumnMetadata).map(RDBColumnMetadata::getFullName).orElse(null);
        return this.createFragments(columnFullName, columnMetadata, selectColumn).map(fragments -> {
            PrepareSqlFragments sqlFragments = PrepareSqlFragments.of().addFragments((SqlFragments)fragments);
            sqlFragments.addSql("as").addSql(this.getAlias(null, finalColumnMetadata, selectColumn));
            return sqlFragments;
        }).orElse(null);
    }

    public Optional<SqlFragments> createFragments(String columnFullName, RDBColumnMetadata columnMetadata, SelectColumn column) {
        String function = column.getFunction();
        if (function != null) {
            return this.metadata.findFeature(FunctionFragmentBuilder.createFeatureId(function)).map(fragment -> fragment.create(columnFullName, columnMetadata, column.getOpts())).map(fragment -> {
                if (fragment.isEmpty()) {
                    throw new UnsupportedOperationException("unsupported function:" + column);
                }
                return fragment;
            });
        }
        return Optional.ofNullable(columnFullName).map(x$0 -> PrepareSqlFragments.of(x$0, new Object[0]));
    }

    @ConstructorProperties(value={"metadata"})
    private SelectColumnFragmentBuilder(TableOrViewMetadata metadata) {
        this.metadata = metadata;
    }

    public static SelectColumnFragmentBuilder of(TableOrViewMetadata metadata) {
        return new SelectColumnFragmentBuilder(metadata);
    }
}

