/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.delete;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.delete.DeleteSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.ForeignKeyTermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.delete.DeleteOperatorParameter;

public class DefaultDeleteSqlBuilder
extends AbstractTermsFragmentBuilder<DeleteOperatorParameter>
implements DeleteSqlBuilder {
    private RDBTableMetadata table;

    @Override
    public SqlRequest build(DeleteOperatorParameter parameter) {
        if (CollectionUtils.isEmpty(parameter.getWhere())) {
            throw new UnsupportedOperationException("Unsupported No Conditions delete");
        }
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        fragments.addSql("delete from", this.table.getFullName(), "where");
        SqlFragments where = this.createTermFragments(parameter, parameter.getWhere());
        if (where.isEmpty()) {
            throw new UnsupportedOperationException("Unsupported No Conditions delete");
        }
        fragments.addFragments(where);
        return fragments.toRequest();
    }

    @Override
    protected SqlFragments createTermFragments(DeleteOperatorParameter parameter, Term term) {
        String columnName = term.getColumn();
        if (columnName == null) {
            return EmptySqlFragments.INSTANCE;
        }
        if (columnName.contains(".")) {
            String[] arr = columnName.split("[.]");
            if (this.table.equalsNameOrAlias(arr[0])) {
                columnName = arr[1];
            } else {
                return this.table.getForeignKey(arr[0]).flatMap(key -> this.table.findFeature(ForeignKeyTermFragmentBuilder.ID).map(builder -> builder.createFragments(this.table.getName(), (ForeignKeyMetadata)key, this.createForeignKeyTerm((ForeignKeyMetadata)key, term)))).orElse(EmptySqlFragments.INSTANCE);
            }
        }
        return this.table.getColumn(columnName).flatMap(column -> column.findFeature(TermFragmentBuilder.createFeatureId(term.getTermType())).map(termFragment -> termFragment.createFragments(column.getQuoteName(), (RDBColumnMetadata)column, term))).orElse(EmptySqlFragments.INSTANCE);
    }

    protected List<Term> createForeignKeyTerm(ForeignKeyMetadata keyMetadata, Term term) {
        Term copy = term.clone();
        term.setTerms(new LinkedList());
        return Collections.singletonList(copy);
    }

    @ConstructorProperties(value={"table"})
    private DefaultDeleteSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }

    public static DefaultDeleteSqlBuilder of(RDBTableMetadata table) {
        return new DefaultDeleteSqlBuilder(table);
    }
}

