/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.function.Function;
import org.hswebframework.ezorm.rdb.metadata.CustomDataType;
import org.hswebframework.ezorm.rdb.metadata.DataTypeBuilderSupport;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.utils.DataTypeUtils;

public interface DataType {
    public String getId();

    public String getName();

    public SQLType getSqlType();

    public Class<?> getJavaType();

    default public boolean isScaleSupport() {
        return this.getSqlType() == JDBCType.DECIMAL || this.getSqlType() == JDBCType.DOUBLE || this.getSqlType() == JDBCType.NUMERIC || this.getSqlType() == JDBCType.FLOAT;
    }

    default public boolean isLengthSupport() {
        return this.isScaleSupport() || this.getSqlType() == JDBCType.VARCHAR || this.getSqlType() == JDBCType.CHAR || this.getSqlType() == JDBCType.NVARCHAR;
    }

    default public boolean isNumber() {
        return DataTypeUtils.typeIsNumber(this);
    }

    public static DataType custom(String id, String name, SQLType sqlType, Class<?> javaType) {
        return CustomDataType.of(id, name, sqlType, javaType);
    }

    public static DataType jdbc(JDBCType jdbcType, Class<?> javaType) {
        return JdbcDataType.of(jdbcType, javaType);
    }

    public static DataType builder(DataType type, Function<RDBColumnMetadata, String> builder) {
        return DataTypeBuilderSupport.of(type, builder);
    }
}

