/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.query;

import java.util.function.Supplier;
import org.hswebframework.ezorm.core.meta.FeatureSupportedMetadata;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.metadata.RDBDatabaseMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryResultOperator;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultQueryResultOperator<E, R>
implements QueryResultOperator<E, R> {
    private Supplier<SqlRequest> sqlRequest;
    private RDBDatabaseMetadata metadata;
    private ResultWrapper<E, R> wrapper;

    public DefaultQueryResultOperator(Supplier<SqlRequest> sqlRequest, TableOrViewMetadata tableOrViewMetadata, ResultWrapper<E, R> wrapper) {
        this.sqlRequest = sqlRequest;
        this.metadata = tableOrViewMetadata.getSchema().getDatabase();
        this.wrapper = wrapper;
    }

    protected ResultWrapper<E, R> getWrapper() {
        return this.wrapper;
    }

    @Override
    public R sync() {
        return (R)ExceptionUtils.translation(() -> ((SyncSqlExecutor)this.metadata.findFeatureNow(SyncSqlExecutor.ID)).select(this.sqlRequest.get(), this.getWrapper()), (FeatureSupportedMetadata)this.metadata);
    }

    @Override
    public Flux<E> reactive() {
        return Flux.defer(() -> ((ReactiveSqlExecutor)this.metadata.findFeatureNow(ReactiveSqlExecutor.ID)).select((Publisher<SqlRequest>)Mono.fromSupplier(this.sqlRequest), this.getWrapper()).onErrorMap(error -> ExceptionUtils.translation((FeatureSupportedMetadata)this.metadata, error)));
    }
}

