/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;

public abstract class AbstractTermFragmentBuilder
implements TermFragmentBuilder {
    private String termType;
    private String name;

    protected List<Object> convertList(RDBColumnMetadata column, Term term) {
        Object value = term.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            value = ((String)value).split(",");
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(val -> this.convertValue(column, val)).collect(Collectors.toList());
        }
        return Arrays.asList(value);
    }

    private Object convertValue(RDBColumnMetadata column, Object val) {
        if (column == null) {
            return val;
        }
        return column.encode(val);
    }

    protected Object convertValue(RDBColumnMetadata column, Term term) {
        return this.convertValue(column, term.getValue());
    }

    @ConstructorProperties(value={"termType", "name"})
    public AbstractTermFragmentBuilder(String termType, String name) {
        this.termType = termType;
        this.name = name;
    }

    @Override
    public String getTermType() {
        return this.termType;
    }

    public void setTermType(String termType) {
        this.termType = termType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

