/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import java.util.function.Consumer;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.AlterRequest;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.AlterTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.ColumnBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.DefaultColumnBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.ForeignKeyDSLBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.IndexBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.TableBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.TableDDLResultOperator;

public class DefaultTableBuilder
implements TableBuilder {
    private RDBTableMetadata table;
    private RDBSchemaMetadata schema;
    private boolean dropColumn = false;
    private boolean allowAlter = true;

    public DefaultTableBuilder(RDBTableMetadata table) {
        this.table = table;
        this.schema = table.getSchema();
    }

    @Override
    public IndexBuilder index() {
        return new IndexBuilder(this, this.table);
    }

    @Override
    public ForeignKeyDSLBuilder foreignKey() {
        return new ForeignKeyDSLBuilder(this.table);
    }

    @Override
    public TableBuilder custom(Consumer<RDBTableMetadata> consumer) {
        consumer.accept(this.table);
        return this;
    }

    @Override
    public TableBuilder addColumn(RDBColumnMetadata column) {
        this.table.addColumn(column);
        return this;
    }

    @Override
    public ColumnBuilder addColumn(String name) {
        RDBColumnMetadata rdbColumnMetaData = this.table.getColumn(name).orElseGet(() -> {
            RDBColumnMetadata columnMetaData = this.table.newColumn();
            columnMetaData.setName(name);
            return columnMetaData;
        });
        return new DefaultColumnBuilder(rdbColumnMetaData, this, this.table);
    }

    @Override
    public TableBuilder removeColumn(String name) {
        this.table.removeColumn(name);
        return this;
    }

    @Override
    public TableBuilder dropColumn(String name) {
        this.table.removeColumn(name);
        this.dropColumn = true;
        return this;
    }

    @Override
    public ColumnBuilder addColumn() {
        RDBColumnMetadata rdbColumnMetaData = this.table.newColumn();
        return new DefaultColumnBuilder(rdbColumnMetaData, this, this.table);
    }

    @Override
    public TableBuilder comment(String comment) {
        this.table.setComment(comment);
        return this;
    }

    @Override
    public TableBuilder alias(String name) {
        this.table.setAlias(name);
        return this;
    }

    @Override
    public TableBuilder allowAlter(boolean allow) {
        this.allowAlter = allow;
        return this;
    }

    @Override
    public TableDDLResultOperator commit() {
        RDBTableMetadata oldTable = this.schema.getTable(this.table.getName()).orElse(null);
        if (oldTable != null) {
            SqlRequest sqlRequest = this.schema.findFeature(AlterTableSqlBuilder.ID).map(builder -> builder.build(AlterRequest.builder().allowDrop(this.dropColumn).newTable(this.table).allowAlter(this.allowAlter).oldTable(oldTable).build())).orElseThrow(() -> new UnsupportedOperationException("Unsupported AlterTableSqlBuilder"));
            return TableDDLResultOperator.of(this.schema, sqlRequest, () -> oldTable.merge(this.table));
        }
        SqlRequest sqlRequest = this.schema.findFeature(CreateTableSqlBuilder.ID).map(builder -> builder.build(this.table)).orElseThrow(() -> new UnsupportedOperationException("Unsupported CreateTableSqlBuilder"));
        return TableDDLResultOperator.of(this.schema, sqlRequest, () -> this.schema.addTable(this.table));
    }
}

