/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.List;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BlockSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.utils.PropertiesUtils;

public abstract class AbstractTermsFragmentBuilder<T> {
    private boolean useBlock = false;

    private BlockSqlFragments createBlockFragments(T parameter, List<Term> terms) {
        BlockSqlFragments fragments = BlockSqlFragments.of();
        int index = 0;
        boolean lastTermAvailable = false;
        for (Term term : terms) {
            SqlFragments nestFragments;
            ++index;
            SqlFragments termFragments = term instanceof SqlTerm ? PrepareSqlFragments.of().addSql(((SqlTerm)term).getSql()).addParameter(PropertiesUtils.convertList(term.getValue())) : (term.getValue() == null ? EmptySqlFragments.INSTANCE : this.createTermFragments(parameter, term));
            boolean termAvailable = termFragments.isNotEmpty();
            if (termAvailable) {
                BlockSqlFragments termBlock = BlockSqlFragments.of();
                if (index != 1 && lastTermAvailable) {
                    termBlock.addBlock(FragmentBlock.before, term.getType().name());
                }
                termBlock.addBlock(FragmentBlock.term, termFragments);
                fragments.addBlock(FragmentBlock.term, termBlock);
            }
            BlockSqlFragments nestBlock = BlockSqlFragments.of();
            List nest = term.getTerms();
            if (nest != null && !nest.isEmpty() && (nestFragments = this.createTermFragments(parameter, nest)).isNotEmpty()) {
                if (termAvailable || lastTermAvailable) {
                    nestBlock.addBlock(FragmentBlock.before, term.getType().name());
                }
                nestBlock.addBlock(FragmentBlock.before, "(");
                nestBlock.addBlock(FragmentBlock.term, nestFragments);
                nestBlock.addBlock(FragmentBlock.after, ")");
                fragments.addBlock(FragmentBlock.term, nestBlock);
                lastTermAvailable = true;
                continue;
            }
            lastTermAvailable = termAvailable;
        }
        return fragments;
    }

    private PrepareSqlFragments createPrepareFragments(T parameter, List<Term> terms) {
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        int index = 0;
        boolean lastTermAvailable = false;
        for (Term term : terms) {
            SqlFragments nestFragments;
            List nest;
            ++index;
            SqlFragments termFragments = term instanceof SqlTerm ? PrepareSqlFragments.of().addSql(((SqlTerm)term).getSql()).addParameter(PropertiesUtils.convertList(term.getValue())) : (term.getValue() == null ? EmptySqlFragments.INSTANCE : this.createTermFragments(parameter, term));
            boolean termAvailable = termFragments.isNotEmpty();
            if (termAvailable) {
                if (index != 1 && lastTermAvailable) {
                    fragments.addSql(term.getType().name());
                }
                fragments.addFragments(termFragments);
            }
            if ((nest = term.getTerms()) != null && !nest.isEmpty() && (nestFragments = this.createTermFragments(parameter, nest)).isNotEmpty()) {
                if (termAvailable || lastTermAvailable) {
                    fragments.addSql(term.getType().name());
                }
                fragments.addSql("(");
                fragments.addFragments(nestFragments);
                fragments.addSql(")");
                lastTermAvailable = true;
                continue;
            }
            lastTermAvailable = termAvailable;
        }
        return fragments;
    }

    protected SqlFragments createTermFragments(T parameter, List<Term> terms) {
        return this.isUseBlock() ? this.createBlockFragments(parameter, terms) : this.createPrepareFragments(parameter, terms);
    }

    protected abstract SqlFragments createTermFragments(T var1, Term var2);

    public void setUseBlock(boolean useBlock) {
        this.useBlock = useBlock;
    }

    public boolean isUseBlock() {
        return this.useBlock;
    }
}

