/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata.key;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.key.AssociationType;
import org.hswebframework.ezorm.rdb.operator.dml.JoinType;

public class ForeignKeyBuilder {
    private String name;
    private String alias;
    private boolean toMany;
    private boolean autoJoin;
    private String source;
    private String target;
    private AssociationType associationType;
    private List<Term> terms = new ArrayList<Term>();
    private JoinType joinType;
    private List<ForeignKeyBuilder> middleForeignKey;
    private List<ForeignKeyColumnBuilder> columns;

    public List<ForeignKeyColumnBuilder> getColumns() {
        return this.columns == null ? (this.columns = new ArrayList<ForeignKeyColumnBuilder>()) : this.columns;
    }

    public List<ForeignKeyBuilder> getMiddleForeignKey() {
        return this.middleForeignKey == null ? (this.middleForeignKey = new ArrayList<ForeignKeyBuilder>()) : this.middleForeignKey;
    }

    public ForeignKeyBuilder addColumn(ForeignKeyColumnBuilder builder) {
        this.getColumns().add(builder);
        return this;
    }

    public ForeignKeyBuilder addMiddle(ForeignKeyBuilder builder) {
        this.getMiddleForeignKey().add(builder);
        return this;
    }

    public ForeignKeyBuilder addColumn(String sourceColumn, String targetColumn) {
        this.getColumns().add(ForeignKeyColumnBuilder.of(sourceColumn, targetColumn));
        return this;
    }

    public static ForeignKeyBuilderBuilder builder() {
        return new ForeignKeyBuilderBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isToMany() {
        return this.toMany;
    }

    public boolean isAutoJoin() {
        return this.autoJoin;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setToMany(boolean toMany) {
        this.toMany = toMany;
    }

    public void setAutoJoin(boolean autoJoin) {
        this.autoJoin = autoJoin;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setAssociationType(AssociationType associationType) {
        this.associationType = associationType;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public void setMiddleForeignKey(List<ForeignKeyBuilder> middleForeignKey) {
        this.middleForeignKey = middleForeignKey;
    }

    public void setColumns(List<ForeignKeyColumnBuilder> columns) {
        this.columns = columns;
    }

    @ConstructorProperties(value={"name", "alias", "toMany", "autoJoin", "source", "target", "associationType", "terms", "joinType", "middleForeignKey", "columns"})
    public ForeignKeyBuilder(String name, String alias, boolean toMany, boolean autoJoin, String source, String target, AssociationType associationType, List<Term> terms, JoinType joinType, List<ForeignKeyBuilder> middleForeignKey, List<ForeignKeyColumnBuilder> columns) {
        this.name = name;
        this.alias = alias;
        this.toMany = toMany;
        this.autoJoin = autoJoin;
        this.source = source;
        this.target = target;
        this.associationType = associationType;
        this.terms = terms;
        this.joinType = joinType;
        this.middleForeignKey = middleForeignKey;
        this.columns = columns;
    }

    public ForeignKeyBuilder() {
    }

    public static class ForeignKeyBuilderBuilder {
        private String name;
        private String alias;
        private boolean toMany;
        private boolean autoJoin;
        private String source;
        private String target;
        private AssociationType associationType;
        private List<Term> terms;
        private JoinType joinType;
        private List<ForeignKeyBuilder> middleForeignKey;
        private List<ForeignKeyColumnBuilder> columns;

        ForeignKeyBuilderBuilder() {
        }

        public ForeignKeyBuilderBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ForeignKeyBuilderBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ForeignKeyBuilderBuilder toMany(boolean toMany) {
            this.toMany = toMany;
            return this;
        }

        public ForeignKeyBuilderBuilder autoJoin(boolean autoJoin) {
            this.autoJoin = autoJoin;
            return this;
        }

        public ForeignKeyBuilderBuilder source(String source) {
            this.source = source;
            return this;
        }

        public ForeignKeyBuilderBuilder target(String target) {
            this.target = target;
            return this;
        }

        public ForeignKeyBuilderBuilder associationType(AssociationType associationType) {
            this.associationType = associationType;
            return this;
        }

        public ForeignKeyBuilderBuilder terms(List<Term> terms) {
            this.terms = terms;
            return this;
        }

        public ForeignKeyBuilderBuilder joinType(JoinType joinType) {
            this.joinType = joinType;
            return this;
        }

        public ForeignKeyBuilderBuilder middleForeignKey(List<ForeignKeyBuilder> middleForeignKey) {
            this.middleForeignKey = middleForeignKey;
            return this;
        }

        public ForeignKeyBuilderBuilder columns(List<ForeignKeyColumnBuilder> columns) {
            this.columns = columns;
            return this;
        }

        public ForeignKeyBuilder build() {
            return new ForeignKeyBuilder(this.name, this.alias, this.toMany, this.autoJoin, this.source, this.target, this.associationType, this.terms, this.joinType, this.middleForeignKey, this.columns);
        }

        public String toString() {
            return "ForeignKeyBuilder.ForeignKeyBuilderBuilder(name=" + this.name + ", alias=" + this.alias + ", toMany=" + this.toMany + ", autoJoin=" + this.autoJoin + ", source=" + this.source + ", target=" + this.target + ", associationType=" + (Object)((Object)this.associationType) + ", terms=" + this.terms + ", joinType=" + (Object)((Object)this.joinType) + ", middleForeignKey=" + this.middleForeignKey + ", columns=" + this.columns + ")";
        }
    }

    public static class ForeignKeyColumnBuilder {
        private String sourceColumn;
        private String targetColumn;

        public String getSourceColumn() {
            return this.sourceColumn;
        }

        public String getTargetColumn() {
            return this.targetColumn;
        }

        @ConstructorProperties(value={"sourceColumn", "targetColumn"})
        private ForeignKeyColumnBuilder(String sourceColumn, String targetColumn) {
            this.sourceColumn = sourceColumn;
            this.targetColumn = targetColumn;
        }

        public static ForeignKeyColumnBuilder of(String sourceColumn, String targetColumn) {
            return new ForeignKeyColumnBuilder(sourceColumn, targetColumn);
        }
    }
}

