/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.jdbc.JdbcSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcSyncSqlExecutor
extends JdbcSqlExecutor
implements SyncSqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(JdbcSyncSqlExecutor.class);

    public JdbcSyncSqlExecutor() {
        super(log);
    }

    public abstract Connection getConnection(SqlRequest var1);

    public abstract void releaseConnection(Connection var1, SqlRequest var2);

    @Override
    public void releaseStatement(Statement statement) {
        statement.close();
    }

    @Override
    public void releaseResultSet(ResultSet resultSet) {
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(SqlRequest request) {
        Connection connection = this.getConnection(request);
        try {
            int n = this.doUpdate(connection, request);
            this.releaseConnection(connection, request);
            return n;
        }
        catch (Throwable throwable) {
            this.releaseConnection(connection, request);
            throw throwable;
        }
    }

    @Override
    public void execute(SqlRequest request) {
        Connection connection = this.getConnection(request);
        try {
            this.doExecute(connection, request);
        }
        finally {
            this.releaseConnection(connection, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, R> R select(SqlRequest request, ResultWrapper<T, R> wrapper) {
        Connection connection = this.getConnection(request);
        try {
            R r = this.doSelect(connection, request, wrapper);
            return r;
        }
        finally {
            this.releaseConnection(connection, request);
        }
    }
}

