/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.Collections;
import java.util.List;
import org.hswebframework.ezorm.rdb.executor.EmptySqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;

public interface SqlFragments {
    public boolean isEmpty();

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public List<String> getSql();

    public List<Object> getParameters();

    default public SqlRequest toRequest() {
        if (this.isEmpty()) {
            return EmptySqlRequest.INSTANCE;
        }
        return SqlRequests.prepare(String.join((CharSequence)" ", this.getSql()), this.getParameters().toArray());
    }

    public static SqlFragments single(final String sql) {
        return new SqlFragments(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public List<String> getSql() {
                return Collections.singletonList(sql);
            }

            @Override
            public List<Object> getParameters() {
                return Collections.emptyList();
            }

            public String toString() {
                return sql;
            }
        };
    }
}

