/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.mapping.SyncDelete;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.SyncRepository;
import org.hswebframework.ezorm.rdb.mapping.SyncUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultRepository;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultSyncDelete;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultSyncQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultSyncUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.dml.QueryOperator;

public class DefaultSyncRepository<E, K>
extends DefaultRepository<E>
implements SyncRepository<E, K> {
    public DefaultSyncRepository(DatabaseOperator operator, String table, Class<E> type, ResultWrapper<E, ?> wrapper) {
        this(operator, () -> operator.getMetadata().getTable(table).orElseThrow(() -> new UnsupportedOperationException("table [" + table + "] doesn't exist")), type, wrapper);
    }

    public DefaultSyncRepository(DatabaseOperator operator, RDBTableMetadata table, Class<E> type, ResultWrapper<E, ?> wrapper) {
        this(operator, () -> table, type, wrapper);
    }

    public DefaultSyncRepository(DatabaseOperator operator, Supplier<RDBTableMetadata> table, Class<E> type, ResultWrapper<E, ?> wrapper) {
        super(operator, table, wrapper);
        this.initMapping(type);
    }

    @Override
    public E newInstance() {
        return this.wrapper.newRowInstance();
    }

    @Override
    public int deleteById(Collection<K> idList) {
        if (idList == null || idList.isEmpty()) {
            return 0;
        }
        return ((SyncDelete)((SyncDelete)this.createDelete().where()).in(this.getIdColumn(), idList)).execute();
    }

    @Override
    public int updateById(K id, E data) {
        if (id == null || data == null) {
            return 0;
        }
        return ((SyncUpdate)((SyncUpdate)this.createUpdate().set(data)).where(this.getIdColumn(), id)).execute();
    }

    @Override
    public SaveResult save(Collection<E> list) {
        return this.doSave(list).sync();
    }

    @Override
    public Optional<E> findById(K primaryKey) {
        return Optional.ofNullable(primaryKey).flatMap(k -> ((SyncQuery)this.createQuery().where(this.getIdColumn(), k)).fetchOne());
    }

    @Override
    public List<E> findById(Collection<K> primaryKey) {
        if (primaryKey.isEmpty()) {
            return new ArrayList();
        }
        return ((SyncQuery)((SyncQuery)this.createQuery().where()).in(this.getIdColumn(), primaryKey)).fetch();
    }

    @Override
    public void insert(E data) {
        this.doInsert(data).sync();
    }

    @Override
    public int insertBatch(Collection<E> batch) {
        if (batch.size() == 0) {
            return 0;
        }
        return this.doInsert(batch).sync();
    }

    @Override
    public SyncQuery<E> createQuery() {
        return new DefaultSyncQuery(this.getTable(), this.mapping, this.operator.dml(), this.wrapper);
    }

    @Override
    public SyncUpdate<E> createUpdate() {
        return new DefaultSyncUpdate(this.getTable(), this.operator.dml().update(this.getTable().getFullName()), this.mapping);
    }

    @Override
    public SyncDelete createDelete() {
        return new DefaultSyncDelete(this.getTable(), this.operator.dml().delete(this.getTable().getFullName()));
    }

    @Override
    public QueryOperator nativeQuery() {
        return this.operator.dml().query(this.getTable());
    }
}

