/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.util.function.Function;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.events.ContextKeys;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultQuery;
import org.hswebframework.ezorm.rdb.mapping.events.DefaultReactiveResultHolder;
import org.hswebframework.ezorm.rdb.mapping.events.EventSupportWrapper;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.DMLOperator;
import org.hswebframework.ezorm.rdb.operator.dml.QueryOperator;
import org.hswebframework.ezorm.rdb.operator.dml.query.Selects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveQuery<T>
extends DefaultQuery<T, ReactiveQuery<T>>
implements ReactiveQuery<T> {
    public DefaultReactiveQuery(TableOrViewMetadata tableMetadata, EntityColumnMapping mapping, DMLOperator operator, ResultWrapper<T, ?> wrapper, ContextKeyValue<?> ... keyValues) {
        super(tableMetadata, mapping, operator, wrapper, keyValues);
    }

    @Override
    public Flux<T> fetch() {
        return this.doFetch(this.operator.query(this.tableMetadata), "fetch", _queryOperator -> ((QueryOperator)_queryOperator.context(this.param.getContext()).select(this.getSelectColumn()).where(this.param.getTerms()).orderBy(this.getSortOrder()).when(this.param.isPaging(), query -> query.paging(this.param.getPageIndex(), this.param.getPageSize()))).fetch(EventSupportWrapper.eventWrapper(this.tableMetadata, this.wrapper, MappingContextKeys.executorType("reactive"), MappingContextKeys.type("fetch"))).reactive());
    }

    @Override
    public Mono<T> fetchOne() {
        return (Mono)this.doFetch(this.operator.query(this.tableMetadata), "fetchOne", _queryOperator -> _queryOperator.context(this.param.getContext()).select(this.getSelectColumn()).where(this.param.getTerms()).orderBy(this.getSortOrder()).paging(0, 1).fetch(EventSupportWrapper.eventWrapper(this.tableMetadata, this.wrapper, MappingContextKeys.executorType("reactive"), MappingContextKeys.type("fetchOne"))).reactive()).as(Mono::from);
    }

    private <O> Flux<O> doFetch(QueryOperator queryOperator, String type, Function<QueryOperator, Publisher<O>> executor) {
        DefaultReactiveResultHolder holder = new DefaultReactiveResultHolder();
        this.tableMetadata.fireEvent((EventType)MappingEventTypes.select_before, eventContext -> eventContext.set(ContextKeys.source(this), MappingContextKeys.query(queryOperator), MappingContextKeys.dml(this.operator), ContextKeys.tableMetadata(this.tableMetadata), MappingContextKeys.columnMapping(this.columnMapping), MappingContextKeys.reactiveResultHolder.value(holder), MappingContextKeys.queryOaram.value(this.param), MappingContextKeys.executorType("reactive"), MappingContextKeys.type(type)));
        return holder.doBefore().thenMany((Publisher)Flux.defer(() -> (Publisher)executor.apply(queryOperator)));
    }

    @Override
    public Mono<Integer> count() {
        QueryOperator queryOperator = this.operator.query(this.tableMetadata).select(Selects.count1().as("total"));
        return (Mono)this.doFetch(queryOperator, "count", _opt -> _opt.context(this.param.getContext()).where(this.param.getTerms()).fetch(ResultWrappers.column("total", Number.class::cast)).reactive().map(Number::intValue).reduce(Math::addExact).switchIfEmpty(Mono.just((Object)0))).as(Mono::from);
    }
}

