/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.query;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QuerySqlFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;

public class SortOrderFragmentBuilder
implements QuerySqlFragmentBuilder {
    private TableOrViewMetadata metadata;

    @Override
    public SqlFragments createFragments(QueryOperatorParameter parameter) {
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        int index = 0;
        for (SortOrder sortOrder : parameter.getOrderBy()) {
            SqlFragments orderFragments = this.createOrder(sortOrder, parameter);
            if (!orderFragments.isNotEmpty()) continue;
            if (index++ != 0) {
                fragments.addSql(",");
            }
            fragments.addFragments(orderFragments);
        }
        return fragments;
    }

    private SqlFragments createOrder(String fullName, RDBColumnMetadata column, SortOrder order) {
        SqlFragments fragments = Optional.ofNullable(order.getFunction()).flatMap(function -> column.findFeature(FunctionFragmentBuilder.createFeatureId(function))).map(builder -> builder.create(fullName, column, order.getOpts())).orElseGet(() -> PrepareSqlFragments.of().addSql(fullName));
        return PrepareSqlFragments.of().addFragments(fragments).addSql(order.getOrder().name());
    }

    private SqlFragments createOrder(SortOrder order, QueryOperatorParameter parameter) {
        String column = order.getColumn();
        if (column.contains(".")) {
            String[] arr = column.split("[.]");
            if (arr[0].equals(parameter.getFrom()) || arr[0].equals(parameter.getFromAlias())) {
                column = arr[1];
            } else {
                return parameter.findJoin(arr[0]).flatMap(join -> this.metadata.getSchema().getTableOrView(join.getTarget()).flatMap(table -> table.getColumn(arr[1])).map(joinColumn -> this.createOrder(joinColumn.getFullName(join.getAlias()), (RDBColumnMetadata)joinColumn, order))).orElse(EmptySqlFragments.INSTANCE);
            }
        }
        return this.metadata.getColumn(column).map(orderColumn -> this.createOrder(orderColumn.getFullName(parameter.getFromAlias()), (RDBColumnMetadata)orderColumn, order)).orElse(EmptySqlFragments.INSTANCE);
    }

    public String getId() {
        return "sortOrderFragmentBuilder";
    }

    public String getName() {
        return "\u6392\u5e8f";
    }

    @ConstructorProperties(value={"metadata"})
    private SortOrderFragmentBuilder(TableOrViewMetadata metadata) {
        this.metadata = metadata;
    }

    public static SortOrderFragmentBuilder of(TableOrViewMetadata metadata) {
        return new SortOrderFragmentBuilder(metadata);
    }
}

