/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.beans.ConstructorProperties;
import java.sql.SQLType;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.FeatureId;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetadata;
import org.hswebframework.ezorm.core.meta.ColumnMetadata;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.core.meta.ObjectType;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBObjectType;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;

public class RDBColumnMetadata
extends AbstractColumnMetadata
implements ColumnMetadata,
Cloneable,
Comparable<RDBColumnMetadata> {
    private String dataType;
    private int length;
    private int precision;
    private int scale;
    private boolean primaryKey;
    private String columnDefinition;
    private boolean updatable = true;
    private boolean insertable = true;
    private boolean saveable = true;
    private DataType type;
    private int sortIndex;
    private TableOrViewMetadata owner;
    private String previousName;

    public Dialect getDialect() {
        return this.getOwner().getDialect();
    }

    public String getQuoteName() {
        return this.getDialect().quote(this.getName());
    }

    public void setJdbcType(SQLType jdbcType, Class javaType) {
        this.javaType = javaType;
        this.setType(JdbcDataType.of(jdbcType, javaType));
    }

    public int getPrecision(int defaultPrecision) {
        return this.precision <= 0 ? defaultPrecision : this.precision;
    }

    public void setType(DataType dataType) {
        this.javaType = dataType.getJavaType();
        this.type = dataType;
    }

    public Class getJavaType() {
        if (this.javaType == null && this.type != null) {
            this.javaType = this.type.getJavaType();
            return this.javaType;
        }
        return super.getJavaType();
    }

    public String getDataType() {
        if (this.dataType != null) {
            return this.dataType;
        }
        return this.getDialect().buildColumnDataType(this);
    }

    public SQLType getSqlType() {
        return Optional.ofNullable(this.type).map(DataType::getSqlType).orElse(null);
    }

    public String getPreviousName() {
        if (this.previousName == null) {
            this.previousName = this.name;
        }
        return this.previousName;
    }

    @Override
    public int compareTo(RDBColumnMetadata target) {
        return Integer.compare(this.sortIndex, target.getSortIndex());
    }

    public RDBColumnMetadata clone() {
        RDBColumnMetadata columnMetadata = (RDBColumnMetadata)super.clone();
        columnMetadata.setProperties(new HashMap(this.getProperties()));
        columnMetadata.setFeatures(new HashMap(this.getFeatures()));
        return columnMetadata;
    }

    public Object encode(Object data) {
        if (data instanceof NullValue) {
            return data;
        }
        return super.encode(data);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        builder.append(" ").append(this.type != null ? this.getDataType() : "");
        if (this.javaType != null) {
            builder.append(" ").append(this.javaType.getSimpleName());
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            builder.append(" /*").append(this.comment).append("*/");
        }
        return builder.toString();
    }

    public ObjectType getObjectType() {
        return RDBObjectType.column;
    }

    public <T extends Feature> Optional<T> findFeature(FeatureId<T> id) {
        return this.findFeature(id.getId());
    }

    public <T extends Feature> Optional<T> findFeature(String id) {
        return Optional.of(this.getFeature(id)).filter(Optional::isPresent).orElseGet(() -> this.owner.findFeature(id));
    }

    public List<Feature> findFeatures(Predicate<Feature> predicate) {
        return Stream.concat(this.owner.findFeatures().stream(), this.getFeatureList().stream()).filter(predicate).collect(Collectors.toList());
    }

    public String getFullName(String ownerName) {
        if (ownerName == null || ownerName.isEmpty()) {
            ownerName = this.getOwner().getName();
        }
        return this.getDialect().buildColumnFullName(ownerName, this.getName());
    }

    public String getFullName() {
        return this.getFullName(this.getOwner().getName());
    }

    public String getFullTableName() {
        return this.getFullName(this.getOwner().getFullName());
    }

    public boolean ddlModifiable(RDBColumnMetadata after) {
        if (!this.getName().equals(this.getPreviousName())) {
            return true;
        }
        DataType type = this.getType();
        if (type != null) {
            if (this.getDialect().buildColumnDataType(this).equals(this.getDialect().buildColumnDataType(after))) {
                return false;
            }
            if (!this.getSqlType().equals(after.getSqlType())) {
                return true;
            }
            if (type.isLengthSupport()) {
                return type.isNumber() ? this.getPrecision() < after.getPrecision() || this.getScale() < after.getScale() : this.getLength() < after.getLength();
            }
            if (type.isScaleSupport()) {
                return this.getScale() < after.getScale();
            }
        }
        return false;
    }

    public void setLength(int length) {
        this.length = length;
        this.setDataType(null);
    }

    public Optional<Object> generateDefaultValue() {
        return Optional.ofNullable(this.defaultValue).filter(RuntimeDefaultValue.class::isInstance).map(RuntimeDefaultValue.class::cast).map(defaultValue -> this.decode(defaultValue.get()));
    }

    public boolean isNotNull() {
        return this.isPrimaryKey() || super.isNotNull();
    }

    public static RDBColumnMetadataBuilder builder() {
        return new RDBColumnMetadataBuilder();
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public DataType getType() {
        return this.type;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public TableOrViewMetadata getOwner() {
        return this.owner;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setSaveable(boolean saveable) {
        this.saveable = saveable;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setOwner(TableOrViewMetadata owner) {
        this.owner = owner;
    }

    public void setPreviousName(String previousName) {
        this.previousName = previousName;
    }

    public RDBColumnMetadata() {
    }

    @ConstructorProperties(value={"dataType", "length", "precision", "scale", "primaryKey", "columnDefinition", "updatable", "insertable", "saveable", "type", "sortIndex", "owner", "previousName"})
    public RDBColumnMetadata(String dataType, int length, int precision, int scale, boolean primaryKey, String columnDefinition, boolean updatable, boolean insertable, boolean saveable, DataType type, int sortIndex, TableOrViewMetadata owner, String previousName) {
        this.dataType = dataType;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.primaryKey = primaryKey;
        this.columnDefinition = columnDefinition;
        this.updatable = updatable;
        this.insertable = insertable;
        this.saveable = saveable;
        this.type = type;
        this.sortIndex = sortIndex;
        this.owner = owner;
        this.previousName = previousName;
    }

    public static class RDBColumnMetadataBuilder {
        private String dataType;
        private int length;
        private int precision;
        private int scale;
        private boolean primaryKey;
        private String columnDefinition;
        private boolean updatable;
        private boolean insertable;
        private boolean saveable;
        private DataType type;
        private int sortIndex;
        private TableOrViewMetadata owner;
        private String previousName;

        RDBColumnMetadataBuilder() {
        }

        public RDBColumnMetadataBuilder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public RDBColumnMetadataBuilder length(int length) {
            this.length = length;
            return this;
        }

        public RDBColumnMetadataBuilder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public RDBColumnMetadataBuilder scale(int scale) {
            this.scale = scale;
            return this;
        }

        public RDBColumnMetadataBuilder primaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public RDBColumnMetadataBuilder columnDefinition(String columnDefinition) {
            this.columnDefinition = columnDefinition;
            return this;
        }

        public RDBColumnMetadataBuilder updatable(boolean updatable) {
            this.updatable = updatable;
            return this;
        }

        public RDBColumnMetadataBuilder insertable(boolean insertable) {
            this.insertable = insertable;
            return this;
        }

        public RDBColumnMetadataBuilder saveable(boolean saveable) {
            this.saveable = saveable;
            return this;
        }

        public RDBColumnMetadataBuilder type(DataType type) {
            this.type = type;
            return this;
        }

        public RDBColumnMetadataBuilder sortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public RDBColumnMetadataBuilder owner(TableOrViewMetadata owner) {
            this.owner = owner;
            return this;
        }

        public RDBColumnMetadataBuilder previousName(String previousName) {
            this.previousName = previousName;
            return this;
        }

        public RDBColumnMetadata build() {
            return new RDBColumnMetadata(this.dataType, this.length, this.precision, this.scale, this.primaryKey, this.columnDefinition, this.updatable, this.insertable, this.saveable, this.type, this.sortIndex, this.owner, this.previousName);
        }

        public String toString() {
            return "RDBColumnMetadata.RDBColumnMetadataBuilder(dataType=" + this.dataType + ", length=" + this.length + ", precision=" + this.precision + ", scale=" + this.scale + ", primaryKey=" + this.primaryKey + ", columnDefinition=" + this.columnDefinition + ", updatable=" + this.updatable + ", insertable=" + this.insertable + ", saveable=" + this.saveable + ", type=" + this.type + ", sortIndex=" + this.sortIndex + ", owner=" + this.owner + ", previousName=" + this.previousName + ")";
        }
    }
}

