/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.events;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.events.ReactiveResultHolder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveResultHolder
implements ReactiveResultHolder {
    private List<Function<Object, Mono<Void>>> afterListener;
    private List<Mono<Void>> beforeListener;
    private List<Mono<Void>> invokeListener;

    public Mono<Object> doAfterNoResult() {
        return this.doAfter(null);
    }

    public Mono<Object> doAfter(Object val) {
        Mono result;
        Mono mono = result = val == null ? Mono.empty() : Mono.just((Object)val);
        if (CollectionUtils.isNotEmpty(this.afterListener)) {
            return Flux.fromIterable(this.afterListener).concatMap(func -> (Mono)func.apply(val)).then(result);
        }
        return result;
    }

    public Mono<Void> doBefore() {
        if (CollectionUtils.isNotEmpty(this.beforeListener)) {
            return Flux.concat(this.beforeListener).then();
        }
        return Mono.empty();
    }

    public Mono<Void> doInvoke() {
        if (CollectionUtils.isNotEmpty(this.invokeListener)) {
            return Flux.concat(this.invokeListener).then();
        }
        return Mono.empty();
    }

    @Override
    public synchronized void after(Function<Object, Mono<Void>> listener) {
        if (this.afterListener == null) {
            this.afterListener = new ArrayList<Function<Object, Mono<Void>>>();
        }
        this.afterListener.add(listener);
    }

    @Override
    public synchronized void before(Mono<Void> listener) {
        if (this.beforeListener == null) {
            this.beforeListener = new ArrayList<Mono<Void>>();
        }
        this.beforeListener.add(listener);
    }

    @Override
    public synchronized void invoke(Mono<Void> listener) {
        if (this.invokeListener == null) {
            this.invokeListener = new ArrayList<Mono<Void>>();
        }
        this.invokeListener.add(listener);
    }

    public List<Function<Object, Mono<Void>>> getAfterListener() {
        return this.afterListener;
    }

    public List<Mono<Void>> getBeforeListener() {
        return this.beforeListener;
    }

    public List<Mono<Void>> getInvokeListener() {
        return this.invokeListener;
    }
}

