/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.hswebframework.ezorm.rdb.operator.ExceptionTranslation;

public class CompositeExceptionTranslation
implements ExceptionTranslation {
    private final List<ExceptionTranslation> translations = new CopyOnWriteArrayList<ExceptionTranslation>();

    @Override
    public Throwable translate(Throwable e) {
        for (ExceptionTranslation translation : this.translations) {
            Throwable newErr = translation.translate(e);
            if (newErr == e) continue;
            return newErr;
        }
        return e;
    }

    public CompositeExceptionTranslation add(ExceptionTranslation translation) {
        this.translations.add(translation);
        return this;
    }

    public CompositeExceptionTranslation add(boolean when, Supplier<ExceptionTranslation> translation) {
        if (when) {
            this.translations.add(translation.get());
        }
        return this;
    }
}

