/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import java.util.function.Consumer;
import org.hswebframework.ezorm.core.DefaultValue;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.ValueCodecFactory;
import org.hswebframework.ezorm.rdb.operator.ddl.ColumnBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.TableBuilder;

public class DefaultColumnBuilder
implements ColumnBuilder {
    private RDBColumnMetadata columnMetaData;
    private TableBuilder tableBuilder;
    private RDBTableMetadata tableMetaData;

    public DefaultColumnBuilder(RDBColumnMetadata columnMetaData, TableBuilder tableBuilder, RDBTableMetadata tableMetaData) {
        this.columnMetaData = columnMetaData;
        this.tableBuilder = tableBuilder;
        this.tableMetaData = tableMetaData;
    }

    @Override
    public ColumnBuilder name(String name) {
        this.columnMetaData.setName(name);
        return this;
    }

    @Override
    public ColumnBuilder custom(Consumer<RDBColumnMetadata> consumer) {
        consumer.accept(this.columnMetaData);
        return this;
    }

    @Override
    public ColumnBuilder alias(String name) {
        this.columnMetaData.setAlias(name);
        return this;
    }

    @Override
    public ColumnBuilder type(String typeId) {
        this.type(this.columnMetaData.getDialect().convertDataType(typeId));
        return this;
    }

    @Override
    public ColumnBuilder dataType(String dataType) {
        this.columnMetaData.setDataType(dataType);
        return this;
    }

    @Override
    public ColumnBuilder type(DataType type) {
        this.columnMetaData.setType(type);
        return this;
    }

    @Override
    public ColumnBuilder comment(String comment) {
        this.columnMetaData.setComment(comment);
        return this;
    }

    @Override
    public ColumnBuilder notNull() {
        this.columnMetaData.setNotNull(true);
        return this;
    }

    @Override
    public ColumnBuilder primaryKey() {
        this.columnMetaData.setPrimaryKey(true);
        return this;
    }

    @Override
    public ColumnBuilder columnDef(String def) {
        this.columnMetaData.setColumnDefinition(def);
        return this;
    }

    @Override
    public ColumnBuilder defaultValue(DefaultValue value) {
        this.columnMetaData.setDefaultValue(value);
        return this;
    }

    @Override
    public ColumnBuilder length(int len) {
        this.columnMetaData.setLength(len);
        return this;
    }

    @Override
    public ColumnBuilder length(int precision, int scale) {
        this.columnMetaData.setLength(precision);
        this.columnMetaData.setScale(scale);
        this.columnMetaData.setPrecision(precision);
        return this;
    }

    @Override
    public ColumnBuilder property(String propertyName, Object value) {
        this.columnMetaData.setProperty(propertyName, value);
        return this;
    }

    @Override
    public TableBuilder commit() {
        if (this.columnMetaData.getValueCodec() == null) {
            this.tableMetaData.findFeature(ValueCodecFactory.ID).flatMap(factory -> factory.createValueCodec(this.columnMetaData)).ifPresent(arg_0 -> ((RDBColumnMetadata)this.columnMetaData).setValueCodec(arg_0));
        }
        this.tableMetaData.addColumn(this.columnMetaData);
        return this.tableBuilder;
    }
}

