/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.jpa;

import java.util.Optional;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.jpa.JpaEntityTableMetadataParserProcessor;
import org.hswebframework.ezorm.rdb.mapping.parser.DataTypeResolver;
import org.hswebframework.ezorm.rdb.mapping.parser.DefaultDataTypeResolver;
import org.hswebframework.ezorm.rdb.mapping.parser.DefaultValueCodecResolver;
import org.hswebframework.ezorm.rdb.mapping.parser.EntityTableMetadataParser;
import org.hswebframework.ezorm.rdb.mapping.parser.ValueCodecResolver;
import org.hswebframework.ezorm.rdb.metadata.RDBDatabaseMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.utils.AnnotationUtils;
import org.hswebframework.utils.ClassUtils;

public class JpaEntityTableMetadataParser
implements EntityTableMetadataParser {
    private RDBDatabaseMetadata databaseMetadata;
    private DataTypeResolver dataTypeResolver = DefaultDataTypeResolver.INSTANCE;
    private ValueCodecResolver valueCodecResolver = DefaultValueCodecResolver.COMMONS;

    @Override
    public Optional<RDBTableMetadata> parseTableMetadata(Class<?> entityType) {
        Table table = AnnotationUtils.getAnnotation(entityType, Table.class);
        if (table == null) {
            return Optional.empty();
        }
        RDBSchemaMetadata schema = this.databaseMetadata.getSchema(table.schema()).orElseGet(() -> ((RDBDatabaseMetadata)this.databaseMetadata).getCurrentSchema());
        RDBTableMetadata tableMetadata = schema.newTable(table.name());
        Optional.ofNullable(ClassUtils.getAnnotation(entityType, Comment.class)).map(Comment::value).ifPresent(tableMetadata::setComment);
        JpaEntityTableMetadataParserProcessor parserProcessor = new JpaEntityTableMetadataParserProcessor(tableMetadata, entityType);
        parserProcessor.setDataTypeResolver(this.dataTypeResolver);
        parserProcessor.setValueCodecResolver(this.valueCodecResolver);
        parserProcessor.process();
        return Optional.of(tableMetadata);
    }

    public void setDatabaseMetadata(RDBDatabaseMetadata databaseMetadata) {
        this.databaseMetadata = databaseMetadata;
    }

    public void setDataTypeResolver(DataTypeResolver dataTypeResolver) {
        this.dataTypeResolver = dataTypeResolver;
    }

    public void setValueCodecResolver(ValueCodecResolver valueCodecResolver) {
        this.valueCodecResolver = valueCodecResolver;
    }
}

