/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlIndexMetadataParser
implements IndexMetadataParser {
    private static final Logger log = LoggerFactory.getLogger(MysqlIndexMetadataParser.class);
    private RDBSchemaMetadata schema;

    @Override
    public List<RDBIndexMetadata> parseTableIndex(String tableName) {
        return this.schema.findFeature(SyncSqlExecutor.ID).map(sqlExecutor -> sqlExecutor.select(SqlRequests.of("show index from ".concat(this.schema.getName()).concat(".").concat(tableName), new Object[0]), new MysqlIndexWrapper())).orElseGet(() -> {
            log.warn("unsupported SyncSqlExecutor");
            return Collections.emptyList();
        });
    }

    public <T extends ObjectMetadata> Optional<T> parseByName(String name) {
        return Optional.empty();
    }

    public <T extends ObjectMetadata> List<T> parseAll() {
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"schema"})
    public MysqlIndexMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public RDBSchemaMetadata getSchema() {
        return this.schema;
    }

    class MysqlIndexWrapper
    implements ResultWrapper<Map<String, String>, List<RDBIndexMetadata>> {
        Map<String, RDBIndexMetadata> groupByName = new HashMap<String, RDBIndexMetadata>();

        MysqlIndexWrapper() {
        }

        @Override
        public Map<String, String> newRowInstance() {
            return new HashMap<String, String>();
        }

        @Override
        public void wrapColumn(ColumnWrapperContext<Map<String, String>> context) {
            if (context.getResult() != null) {
                context.getRowInstance().put(context.getColumnLabel().toLowerCase(), String.valueOf(context.getResult()));
            }
        }

        @Override
        public boolean completedWrapRow(Map<String, String> result) {
            String name = result.get("key_name");
            RDBIndexMetadata index = this.groupByName.computeIfAbsent(name, __ -> new RDBIndexMetadata());
            index.setName(result.get("key_name"));
            index.setUnique("0".equals(result.get("non_unique")));
            index.setTableName(result.get("table"));
            index.setPrimaryKey("PRIMARY".equalsIgnoreCase(name));
            RDBIndexMetadata.IndexColumn column = new RDBIndexMetadata.IndexColumn();
            column.setColumn(result.get("column_name"));
            column.setSortIndex(Integer.parseInt(result.get("seq_in_index")));
            column.setSort(RDBIndexMetadata.IndexSort.asc);
            index.getColumns().add(column);
            return true;
        }

        @Override
        public List<RDBIndexMetadata> getResult() {
            return new LinkedList<RDBIndexMetadata>(this.groupByName.values());
        }
    }
}

