/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.h2;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2IndexMetadataParser
implements IndexMetadataParser {
    private static final Logger log = LoggerFactory.getLogger(H2IndexMetadataParser.class);
    private RDBSchemaMetadata schema;
    private static final String sql = "select index_name,table_name,column_name,primary_key,asc_or_desc,ordinal_position,non_unique from information_schema.indexes where table_name=? and table_schema=?";
    private static final String byName = "select index_name,table_name,column_name,primary_key,asc_or_desc,ordinal_position,non_unique from information_schema.indexes where index_name=? and table_schema=?";
    private static final String all = "select index_name,table_name,column_name,primary_key,asc_or_desc,ordinal_position,non_unique from information_schema.indexes where table_schema=?";

    @Override
    public List<RDBIndexMetadata> parseTableIndex(String tableName) {
        return this.doSelect(SqlRequests.of(sql, tableName.toUpperCase(), this.schema.getName().toUpperCase()));
    }

    public Optional<RDBIndexMetadata> parseByName(String name) {
        return this.doSelect(SqlRequests.of(byName, name.toUpperCase(), this.schema.getName().toUpperCase())).stream().findFirst();
    }

    public List<RDBIndexMetadata> parseAll() {
        return this.doSelect(SqlRequests.of(all, this.schema.getName().toUpperCase()));
    }

    protected List<RDBIndexMetadata> doSelect(SqlRequest sqlRequest) {
        return this.schema.findFeature(SyncSqlExecutor.ID).map(sqlExecutor -> sqlExecutor.select(sqlRequest, new H2IndexMetadataWrapper())).orElseGet(() -> {
            log.warn("unsupported SyncSqlExecutor");
            return Collections.emptyList();
        });
    }

    @ConstructorProperties(value={"schema"})
    public H2IndexMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    class H2IndexMetadataWrapper
    implements ResultWrapper<Map<String, Object>, List<RDBIndexMetadata>> {
        Map<String, RDBIndexMetadata> group = new LinkedHashMap<String, RDBIndexMetadata>();

        H2IndexMetadataWrapper() {
        }

        @Override
        public Map<String, Object> newRowInstance() {
            return new HashMap<String, Object>();
        }

        @Override
        public void wrapColumn(ColumnWrapperContext<Map<String, Object>> context) {
            context.getRowInstance().put(context.getColumnLabel().toLowerCase(), context.getResult());
        }

        @Override
        public boolean completedWrapRow(Map<String, Object> result) {
            String name = (String)result.get("index_name");
            RDBIndexMetadata index = this.group.computeIfAbsent(name, __ -> new RDBIndexMetadata());
            index.setName(name.toLowerCase());
            index.setTableName(((String)result.get("table_name")).toLowerCase());
            index.setPrimaryKey(Boolean.TRUE.equals(result.get("primary_key")));
            index.setUnique(Boolean.FALSE.equals(result.get("non_unique")));
            RDBIndexMetadata.IndexColumn indexColumn = new RDBIndexMetadata.IndexColumn();
            indexColumn.setColumn(((String)result.get("column_name")).toLowerCase());
            indexColumn.setSort("A".equals(result.get("asc_or_desc")) ? RDBIndexMetadata.IndexSort.asc : RDBIndexMetadata.IndexSort.desc);
            indexColumn.setSortIndex(((Number)result.get("ordinal_position")).intValue());
            index.getColumns().add(indexColumn);
            return true;
        }

        @Override
        public List<RDBIndexMetadata> getResult() {
            return new ArrayList<RDBIndexMetadata>(this.group.values());
        }
    }
}

