/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import java.beans.ConstructorProperties;
import org.hswebframework.ezorm.core.meta.FeatureSupportedMetadata;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.operator.ResultOperator;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class TableDDLResultOperator
implements ResultOperator<Boolean, Boolean> {
    private RDBSchemaMetadata schema;
    private SqlRequest sqlRequest;
    private Runnable whenCompleted;

    @Override
    public Boolean sync() {
        return ExceptionUtils.translation(() -> this.schema.findFeature(SyncSqlExecutor.ID).map(sqlExecutor -> {
            sqlExecutor.execute(this.sqlRequest);
            this.whenCompleted.run();
            return true;
        }).orElseThrow(() -> new UnsupportedOperationException("Unsupported SyncSqlExecutor")), (FeatureSupportedMetadata)this.schema);
    }

    @Override
    public Mono<Boolean> reactive() {
        return ((ReactiveSqlExecutor)this.schema.findFeatureNow(ReactiveSqlExecutor.ID)).execute((Publisher<SqlRequest>)Mono.just((Object)this.sqlRequest)).doOnSuccess(__ -> this.whenCompleted.run()).thenReturn((Object)true).onErrorMap(error -> ExceptionUtils.translation((FeatureSupportedMetadata)this.schema, error));
    }

    @ConstructorProperties(value={"schema", "sqlRequest", "whenCompleted"})
    private TableDDLResultOperator(RDBSchemaMetadata schema, SqlRequest sqlRequest, Runnable whenCompleted) {
        this.schema = schema;
        this.sqlRequest = sqlRequest;
        this.whenCompleted = whenCompleted;
    }

    public static TableDDLResultOperator of(RDBSchemaMetadata schema, SqlRequest sqlRequest, Runnable whenCompleted) {
        return new TableDDLResultOperator(schema, sqlRequest, whenCompleted);
    }
}

