/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.FeatureType;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.core.meta.FeatureSupportedMetadata;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;

public class FeatureUtils {
    private static boolean r2dbcIsAlive;

    public static boolean r2dbcIsAlive() {
        return r2dbcIsAlive;
    }

    public static String featureToString(List<Feature> features) {
        StringBuilder builder = new StringBuilder();
        Map featureMap = features.stream().collect(Collectors.groupingBy(Feature::getType, () -> new TreeMap(Comparator.comparing(FeatureType::getId)), Collectors.toList()));
        for (Map.Entry entry : featureMap.entrySet()) {
            builder.append("--").append(((FeatureType)entry.getKey()).getId()).append(" (").append(((FeatureType)entry.getKey()).getName()).append(")").append("\n");
            for (Feature feature : (List)entry.getValue()) {
                builder.append("-----|---- ").append(feature.getId()).append(" (").append(feature.getName()).append(")").append("\t").append(feature.getClass().getSimpleName()).append("\n");
            }
        }
        return builder.toString();
    }

    public static String metadataToString(ObjectMetadata metadata) {
        StringBuilder builder = new StringBuilder();
        builder.append(metadata.getObjectType().getId()).append("(").append(metadata.getObjectType().getName()).append(")");
        if (metadata instanceof FeatureSupportedMetadata) {
            builder.append("\n").append(FeatureUtils.featureToString(((FeatureSupportedMetadata)metadata).getFeatureList()));
        }
        return builder.toString();
    }

    static {
        try {
            Class.forName("io.r2dbc.spi.Connection");
            r2dbcIsAlive = true;
        }
        catch (ClassNotFoundException e) {
            r2dbcIsAlive = false;
        }
    }
}

