/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.postgres;

import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.CompositeExceptionTranslation;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlAlterTableSqlBuilder;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlIndexMetadataParser;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlPaginator;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlR2DBCExceptionTranslation;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlSaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.supports.postgres.PostgresqlTableMetadataParser;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;

public class PostgresqlSchemaMetadata
extends RDBSchemaMetadata {
    public PostgresqlSchemaMetadata(String name) {
        super(name);
        this.addFeature(new PostgresqlPaginator());
        this.addFeature(new PostgresqlAlterTableSqlBuilder());
        this.addFeature((Feature)new PostgresqlTableMetadataParser(this));
        this.addFeature((Feature)new PostgresqlIndexMetadataParser(this));
        this.addFeature(Dialect.POSTGRES);
        this.addFeature(new CompositeExceptionTranslation().add(FeatureUtils.r2dbcIsAlive(), () -> PostgresqlR2DBCExceptionTranslation.of(this)));
    }

    @Override
    public void addTable(RDBTableMetadata metadata) {
        metadata.addFeature(new PostgresqlSaveOrUpdateOperator(metadata));
        super.addTable(metadata);
    }

    @Override
    public RDBTableMetadata newTable(String name) {
        RDBTableMetadata metadata = super.newTable(name);
        metadata.addFeature(new PostgresqlSaveOrUpdateOperator(metadata));
        return metadata;
    }
}

