/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.postgres;

import java.math.BigDecimal;
import java.sql.JDBCType;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.DefaultDialect;
import org.hswebframework.ezorm.rdb.supports.postgres.JsonType;
import org.hswebframework.ezorm.rdb.supports.postgres.JsonbType;
import org.hswebframework.utils.StringUtils;

public class PostgresqlDialect
extends DefaultDialect {
    public PostgresqlDialect() {
        this.addDataTypeBuilder(JDBCType.CHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.VARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.TIMESTAMP, (RDBColumnMetadata meta) -> "timestamp");
        this.addDataTypeBuilder(JDBCType.TIME, (RDBColumnMetadata meta) -> "time");
        this.addDataTypeBuilder(JDBCType.DATE, (RDBColumnMetadata meta) -> "date");
        this.addDataTypeBuilder(JDBCType.CLOB, (RDBColumnMetadata meta) -> "text");
        this.addDataTypeBuilder(JDBCType.LONGVARBINARY, (RDBColumnMetadata meta) -> "bytea");
        this.addDataTypeBuilder(JDBCType.LONGVARCHAR, (RDBColumnMetadata meta) -> "text");
        this.addDataTypeBuilder(JDBCType.BLOB, (RDBColumnMetadata meta) -> "bytea");
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "int8");
        this.addDataTypeBuilder(JDBCType.DOUBLE, (RDBColumnMetadata meta) -> "double");
        this.addDataTypeBuilder(JDBCType.INTEGER, (RDBColumnMetadata meta) -> "integer");
        this.addDataTypeBuilder(JDBCType.NUMERIC, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.DECIMAL, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.TINYINT, (RDBColumnMetadata meta) -> "smallint");
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "bigint");
        this.addDataTypeBuilder(JDBCType.OTHER, (RDBColumnMetadata meta) -> "other");
        this.addDataTypeBuilder("json", (RDBColumnMetadata meta) -> "json");
        this.addDataTypeBuilder("jsonb", (RDBColumnMetadata meta) -> "jsonb");
        this.registerDataType("json", JsonType.INSTANCE);
        this.registerDataType("jsonb", JsonbType.INSTANCE);
        this.registerDataType("clob", DataType.builder(JdbcDataType.of(JDBCType.LONGVARCHAR, String.class), c -> "text"));
        this.registerDataType("blob", DataType.builder(JdbcDataType.of(JDBCType.BLOB, String.class), c -> "bytea"));
        this.registerDataType("longnvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGNVARCHAR, String.class), c -> "text"));
        this.registerDataType("longvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGVARCHAR, String.class), c -> "text"));
        this.registerDataType("int8", JdbcDataType.of(JDBCType.BIGINT, Integer.class));
        this.registerDataType("int4", JdbcDataType.of(JDBCType.INTEGER, Integer.class));
        this.registerDataType("int2", JdbcDataType.of(JDBCType.TINYINT, Byte.class));
        this.registerDataType("int", JdbcDataType.of(JDBCType.INTEGER, Integer.class));
        this.registerDataType("flat8", JdbcDataType.of(JDBCType.DOUBLE, Double.class));
        this.registerDataType("money", JdbcDataType.of(JDBCType.DECIMAL, BigDecimal.class));
        this.registerDataType("bool", JdbcDataType.of(JDBCType.BOOLEAN, Boolean.class));
        this.registerDataType("character", JdbcDataType.of(JDBCType.VARCHAR, String.class));
        this.registerDataType("xml", JdbcDataType.of(JDBCType.VARCHAR, String.class));
        this.registerDataType("year", JdbcDataType.of(JDBCType.TIME, String.class));
        this.registerDataType("datetime", JdbcDataType.of(JDBCType.TIMESTAMP, String.class));
        this.registerDataType("text", JdbcDataType.of(JDBCType.LONGVARCHAR, String.class));
    }

    @Override
    public String getQuoteStart() {
        return "\"";
    }

    @Override
    public String getQuoteEnd() {
        return "\"";
    }

    @Override
    public boolean isColumnToUpperCase() {
        return false;
    }

    public String getId() {
        return "PostgreSQL";
    }

    public String getName() {
        return "PostgreSQL";
    }
}

