/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MysqlSaveOrUpdateOperator
implements SaveOrUpdateOperator {
    private RDBTableMetadata table;
    public MysqlUpsertBatchInsertSqlBuilder builder;

    public MysqlSaveOrUpdateOperator(RDBTableMetadata table) {
        this.table = table;
        this.builder = new MysqlUpsertBatchInsertSqlBuilder(table);
    }

    @Override
    public SaveResultOperator execute(InsertOperatorParameter parameter) {
        return new MysqlSaveResultOperator(() -> parameter.getValues().stream().map(value -> {
            InsertOperatorParameter newParam = new InsertOperatorParameter();
            newParam.setColumns(parameter.getColumns());
            newParam.getValues().add((List<Object>)value);
            return newParam;
        }).map(this.builder::build).collect(Collectors.toList()));
    }

    private class MysqlUpsertBatchInsertSqlBuilder
    extends BatchInsertSqlBuilder {
        public MysqlUpsertBatchInsertSqlBuilder(RDBTableMetadata table) {
            super(table);
        }

        @Override
        protected void afterValues(Set<InsertColumn> columns, List<Object> values, PrepareSqlFragments sql) {
            sql.addSql("on duplicate key update");
            int index = 0;
            boolean more = false;
            for (InsertColumn column : columns) {
                Object value = index >= values.size() ? null : values.get(index);
                ++index;
                RDBColumnMetadata columnMetadata = MysqlSaveOrUpdateOperator.this.table.getColumn(column.getColumn()).orElse(null);
                if (value == null || columnMetadata == null || columnMetadata.isPrimaryKey() || !columnMetadata.isUpdatable()) continue;
                if (more) {
                    sql.addSql(",");
                }
                more = true;
                sql.addSql(columnMetadata.getQuoteName()).addSql("=");
                if (value instanceof NativeSql) {
                    sql.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                sql.addSql("?").addParameter(columnMetadata.encode(value));
            }
        }
    }

    private class MysqlSaveResultOperator
    implements SaveResultOperator {
        Supplier<List<SqlRequest>> sqlRequest;

        @Override
        public SaveResult sync() {
            return ExceptionUtils.translation(() -> {
                SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)MysqlSaveOrUpdateOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
                int added = 0;
                int updated = 0;
                for (SqlRequest request : this.sqlRequest.get()) {
                    int num = sqlExecutor.update(request);
                    if (num == 0) {
                        ++updated;
                        continue;
                    }
                    ++added;
                }
                return SaveResult.of(added, updated);
            }, MysqlSaveOrUpdateOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return Mono.defer(() -> {
                ReactiveSqlExecutor sqlExecutor = (ReactiveSqlExecutor)MysqlSaveOrUpdateOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID);
                return Flux.fromIterable((Iterable)this.sqlRequest.get()).flatMap(sql -> sqlExecutor.update((Publisher<SqlRequest>)Mono.just((Object)sql))).map(i -> SaveResult.of(i > 0 ? 1 : 0, i == 0 ? 1 : 0)).reduce(SaveResult::merge).onErrorMap(err -> ExceptionUtils.translation(MysqlSaveOrUpdateOperator.this.table, err));
            });
        }

        @ConstructorProperties(value={"sqlRequest"})
        public MysqlSaveResultOperator(Supplier<List<SqlRequest>> sqlRequest) {
            this.sqlRequest = sqlRequest;
        }
    }
}

