/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mssql;

import java.math.BigDecimal;
import java.sql.JDBCType;
import java.util.Date;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.DefaultDialect;
import org.hswebframework.utils.StringUtils;

public class SqlServerDialect
extends DefaultDialect {
    public SqlServerDialect() {
        this.addDataTypeBuilder(JDBCType.CHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.NCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"nchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.VARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.NVARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"nvarchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.TIMESTAMP, (RDBColumnMetadata meta) -> "datetime2");
        this.addDataTypeBuilder(JDBCType.TIME, (RDBColumnMetadata meta) -> "time");
        this.addDataTypeBuilder(JDBCType.DATE, (RDBColumnMetadata meta) -> "date");
        this.addDataTypeBuilder(JDBCType.CLOB, (RDBColumnMetadata meta) -> "text");
        this.addDataTypeBuilder(JDBCType.LONGVARBINARY, (RDBColumnMetadata meta) -> "varbinary(max)");
        this.addDataTypeBuilder(JDBCType.LONGVARCHAR, (RDBColumnMetadata meta) -> "text");
        this.addDataTypeBuilder(JDBCType.BLOB, (RDBColumnMetadata meta) -> "varbinary(max)");
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "bigint");
        this.addDataTypeBuilder(JDBCType.DOUBLE, (RDBColumnMetadata meta) -> "double");
        this.addDataTypeBuilder(JDBCType.INTEGER, (RDBColumnMetadata meta) -> "int");
        this.addDataTypeBuilder(JDBCType.NUMERIC, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.DECIMAL, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"numeric(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.TINYINT, (RDBColumnMetadata meta) -> "tinyint");
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "bigint");
        this.addDataTypeBuilder(JDBCType.OTHER, (RDBColumnMetadata meta) -> "other");
        this.addDataTypeBuilder(JDBCType.REAL, (RDBColumnMetadata meta) -> "real");
        this.registerDataType("longnvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGNVARCHAR, String.class), c -> "text"));
        this.registerDataType("longvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGVARCHAR, String.class), c -> "text"));
        this.registerDataType("datetime2", JdbcDataType.of(JDBCType.TIMESTAMP, Date.class));
        this.registerDataType("datetime", JdbcDataType.of(JDBCType.TIMESTAMP, Date.class));
        this.registerDataType("nvarchar", JdbcDataType.of(JDBCType.NVARCHAR, String.class));
        this.registerDataType("image", JdbcDataType.of(JDBCType.LONGVARBINARY, byte[].class));
        this.registerDataType("int", JdbcDataType.of(JDBCType.INTEGER, Integer.class));
        this.registerDataType("money", JdbcDataType.of(JDBCType.DECIMAL, Integer.class));
        this.registerDataType("nchar", JdbcDataType.of(JDBCType.CHAR, String.class));
        this.registerDataType("ntext", JdbcDataType.of(JDBCType.LONGVARCHAR, String.class));
        this.registerDataType("real", JdbcDataType.of(JDBCType.REAL, String.class));
        this.registerDataType("smalldatetime", JdbcDataType.of(JDBCType.TIMESTAMP, java.sql.Date.class));
        this.registerDataType("smallint", JdbcDataType.of(JDBCType.SMALLINT, Short.class));
        this.registerDataType("smallmoney", JdbcDataType.of(JDBCType.DECIMAL, BigDecimal.class));
        this.registerDataType("text", JdbcDataType.of(JDBCType.CLOB, String.class));
        this.registerDataType("tinyint", JdbcDataType.of(JDBCType.TINYINT, Byte.class));
        this.registerDataType("varbinary", JdbcDataType.of(JDBCType.VARBINARY, byte[].class));
        this.registerDataType("tinyint", JdbcDataType.of(JDBCType.TINYINT, Byte.class));
    }

    @Override
    public String getQuoteStart() {
        return "[";
    }

    @Override
    public String getQuoteEnd() {
        return "]";
    }

    @Override
    public boolean isColumnToUpperCase() {
        return false;
    }

    public String getId() {
        return "microsoft-mssql-server";
    }

    public String getName() {
        return "Microsoft MSSQL Server";
    }
}

