/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.upsert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperator;

public class DefaultUpsertOperator
extends UpsertOperator {
    private InsertOperatorParameter parameter = new InsertOperatorParameter();
    private RDBTableMetadata table;
    private boolean columnValueModel = false;

    public static DefaultUpsertOperator of(RDBTableMetadata table) {
        DefaultUpsertOperator operator = new DefaultUpsertOperator();
        operator.setTable(table);
        return operator;
    }

    @Override
    public UpsertOperator columns(String ... columns) {
        for (String column : columns) {
            this.parameter.getColumns().add(InsertColumn.of(column));
        }
        this.columnValueModel = true;
        return this;
    }

    @Override
    public UpsertOperator values(Object ... values) {
        this.parameter.getValues().add(Arrays.asList(values));
        this.columnValueModel = true;
        return this;
    }

    @Override
    public UpsertOperator values(List<Map<String, Object>> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        Set<String> keys = values.get(0).keySet();
        this.columns(keys.toArray(new String[0]));
        for (Map<String, Object> value : values) {
            this.values(keys.stream().map(value::get).toArray());
        }
        return this;
    }

    @Override
    public UpsertOperator value(String column, Object value) {
        if (this.columnValueModel) {
            throw new UnsupportedOperationException("columns or values already set");
        }
        this.parameter.getColumns().add(InsertColumn.of(column));
        List<List<Object>> values = this.parameter.getValues();
        if (values.isEmpty()) {
            values.add(new ArrayList());
        }
        values.get(0).add(value);
        return this;
    }

    @Override
    public SaveResultOperator execute() {
        return ((SaveOrUpdateOperator)this.table.findFeatureNow(SaveOrUpdateOperator.ID)).execute(this.getParameter());
    }

    public InsertOperatorParameter getParameter() {
        return this.parameter;
    }

    public void setTable(RDBTableMetadata table) {
        this.table = table;
    }
}

